/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.InstrumentedComponent;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.ProtocolViolationException;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscription;

@Internal
interface RxInstrumentedComponent
extends InstrumentedComponent {
    @Override
    default public void onStateError(Throwable t) {
        RxJavaPlugins.onError((Throwable)t);
    }

    @Override
    default public boolean validate(Subscription current, Subscription next) {
        if (next == null) {
            RxJavaPlugins.onError((Throwable)new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            RxJavaPlugins.onError((Throwable)new ProtocolViolationException("Subscription already set!"));
            return false;
        }
        return true;
    }

    default public boolean validate(Disposable current, Disposable next) {
        if (next == null) {
            RxJavaPlugins.onError((Throwable)new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.dispose();
            RxJavaPlugins.onError((Throwable)new ProtocolViolationException("Disposable already set!"));
            return false;
        }
        return true;
    }
}

