/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedWrappers;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedConnectableFlowable<T>
extends ConnectableFlowable<T>
implements RxInstrumentedComponent {
    private final ConnectableFlowable<T> source;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedConnectableFlowable(ConnectableFlowable<T> source, List<RunnableInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedConnectableFlowable(ConnectableFlowable<T> source, Collection<ReactiveInstrumenter> instrumentations) {
        this.source = source;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(RxInstrumentedWrappers.wrap(s, this.instrumentations));
    }

    public void connect(Consumer<? super Disposable> connection) {
        Runnable connectRunnable = () -> this.source.connect(connection);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            connectRunnable = instrumentation.instrument(connectRunnable);
        }
        connectRunnable.run();
    }
}

