/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Primary
public class DefaultCacheManager<C>
implements CacheManager<C> {
    private final Map<String, SyncCache<C>> cacheMap;

    @Inject
    public DefaultCacheManager(List<SyncCache<C>> caches) {
        if (CollectionUtils.isEmpty(caches)) {
            this.cacheMap = Collections.emptyMap();
        } else {
            this.cacheMap = new LinkedHashMap<String, SyncCache<C>>(caches.size());
            for (SyncCache<C> cache : caches) {
                String cacheName = cache.getName();
                if (this.cacheMap.containsKey(cacheName)) {
                    throw new ConfigurationException("Cannot registry duplicate cache [" + cache + "] with cache manager. Ensure configured cache names are unique. Cache already configured for name [" + cacheName + "]: " + this.cacheMap.get(cacheName));
                }
                this.cacheMap.put(cacheName, cache);
            }
        }
    }

    public DefaultCacheManager(SyncCache<C> ... caches) {
        this(Arrays.asList(caches));
    }

    @Override
    @Nonnull
    public Set<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    @Override
    @Nonnull
    public SyncCache<C> getCache(String name) {
        SyncCache<C> cache = this.cacheMap.get(name);
        if (cache == null) {
            throw new ConfigurationException("No cache configured for name: " + name);
        }
        return cache;
    }
}

