/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@BootstrapContextCompatible
public class JsonMediaTypeCodec
implements MediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "json";
    private final ObjectMapper objectMapper;
    private final ApplicationConfiguration applicationConfiguration;
    private final List<MediaType> additionalTypes;

    public JsonMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        this.objectMapper = objectMapper;
        this.applicationConfiguration = applicationConfiguration;
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean supportsType(Class<?> type) {
        return !CharSequence.class.isAssignableFrom(type);
    }

    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON_TYPE);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }

    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.objectMapper.readValue(inputStream, javaType);
            }
            return (T)this.objectMapper.readValue(inputStream, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    public <T> T decode(Argument<T> type, JsonNode node) throws CodecException {
        try {
            return (T)this.objectMapper.treeToValue((TreeNode)node, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        try {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                return (T)buffer.toString(this.applicationConfiguration.getDefaultCharset());
            }
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.objectMapper.readValue(buffer.toByteArray(), javaType);
            }
            return (T)this.objectMapper.readValue(buffer.toByteArray(), type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getType() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, String data) throws CodecException {
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.objectMapper.readValue(data, javaType);
            }
            return (T)this.objectMapper.readValue(data, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        try {
            this.objectMapper.writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> byte[] encode(T object) throws CodecException {
        try {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> ByteBuffer encode(T object, ByteBufferFactory allocator) throws CodecException {
        byte[] bytes = this.encode(object);
        return allocator.copiedBuffer(bytes);
    }

    private <T> JavaType constructJavaType(Argument<T> type) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return JacksonConfiguration.constructType(type, typeFactory);
    }
}

