/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.reactor.converters;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requires(classes={Flux.class})
public class ObjectToFluxConverter
implements TypeConverter<Object, Flux> {
    public Optional<Flux> convert(Object object, Class<Flux> targetType, ConversionContext context) {
        if (object instanceof Publisher) {
            return Optional.of(Flux.from((Publisher)((Publisher)object)));
        }
        if (object instanceof Iterable) {
            return Optional.of(Flux.fromIterable((Iterable)((Iterable)object)));
        }
        return Optional.of(Flux.just((Object)object));
    }
}

