/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.reactive.rxjava2.InstrumentedComponent;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
abstract class InstrumentedSubscriber<T>
implements Subscriber<T>,
InstrumentedComponent {
    protected boolean done;
    Subscription upstream;
    private final Subscriber<T> downstream;
    private final List<RunnableInstrumenter> instrumentations;

    InstrumentedSubscriber(Subscriber<T> downstream, Collection<ReactiveInstrumenter> instrumentations) {
        ArgumentUtils.requireNonNull((String)"downstream", downstream);
        this.downstream = downstream;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    InstrumentedSubscriber(Subscriber<T> downstream, List<RunnableInstrumenter> instrumentations) {
        ArgumentUtils.requireNonNull((String)"downstream", downstream);
        this.downstream = downstream;
        this.instrumentations = instrumentations;
    }

    public final void onSubscribe(Subscription s) {
        if (!this.validate(this.upstream, s)) {
            return;
        }
        this.upstream = s;
        this.downstream.onSubscribe(this.upstream);
    }

    public void onNext(T t) {
        Runnable onNextRunnable = () -> this.downstream.onNext(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onNextRunnable = instrumentation.instrument(onNextRunnable);
        }
        onNextRunnable.run();
    }

    public void onError(Throwable t) {
        if (this.done) {
            this.onStateError(t);
            return;
        }
        this.done = true;
        Runnable onNextRunnable = () -> this.downstream.onError(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onNextRunnable = instrumentation.instrument(onNextRunnable);
        }
        onNextRunnable.run();
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Runnable onCompleteRunnable = () -> this.downstream.onComplete();
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onCompleteRunnable = instrumentation.instrument(onCompleteRunnable);
        }
        onCompleteRunnable.run();
    }
}

