/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.List;

@Internal
final class RxInstrumentedMaybeObserver<T>
implements MaybeObserver<T>,
Disposable,
RxInstrumentedComponent {
    private final MaybeObserver<T> downstream;
    private Disposable upstream;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedMaybeObserver(MaybeObserver<T> downstream, List<RunnableInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedMaybeObserver(MaybeObserver<T> downstream, Collection<ReactiveInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    public void onSubscribe(Disposable d) {
        if (!this.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onError(Throwable t) {
        Runnable onError = () -> this.downstream.onError(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onError = instrumentation.instrument(onError);
        }
        onError.run();
    }

    public void onSuccess(T value) {
        Runnable onSuccess = () -> this.downstream.onSuccess(value);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onSuccess = instrumentation.instrument(onSuccess);
        }
        onSuccess.run();
    }

    public void onComplete() {
        Runnable onComplete = () -> this.downstream.onComplete();
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onComplete = instrumentation.instrument(onComplete);
        }
        onComplete.run();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void dispose() {
        this.upstream.dispose();
    }
}

