/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.List;

@Internal
final class RxInstrumentedObserver<T>
implements Observer<T>,
Disposable,
RxInstrumentedComponent {
    protected boolean done;
    protected final Observer<T> downstream;
    private final List<RunnableInstrumenter> instrumentations;
    private Disposable upstream;

    RxInstrumentedObserver(Observer<T> downstream, List<RunnableInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedObserver(Observer<T> downstream, Collection<ReactiveInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    public void onSubscribe(Disposable d) {
        if (!this.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onNext(T t) {
        Runnable onNext = () -> this.downstream.onNext(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onNext = instrumentation.instrument(onNext);
        }
        onNext.run();
    }

    public void onError(Throwable t) {
        if (this.done) {
            this.onStateError(t);
            return;
        }
        this.done = true;
        Runnable onError = () -> this.downstream.onError(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onError = instrumentation.instrument(onError);
        }
        onError.run();
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Runnable onComplete = () -> this.downstream.onComplete();
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onComplete = instrumentation.instrument(onComplete);
        }
        onComplete.run();
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }
}

