/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.reactive.rxjava2.RxInstrumentedWrappers;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Function;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Context
@Requires(classes={Flowable.class})
@Internal
@TypeHint(value={Completable.class, Single.class, Flowable.class, Maybe.class, Observable.class})
class RxJava2Instrumentation
implements Function<Runnable, Runnable>,
AutoCloseable {
    private final List<RunnableInstrumenter> instrumenters;
    private final List<ReactiveInstrumenter> reactiveInstrumenters;
    private Function<? super Completable, ? extends Completable> oldCompletableHook;
    private Function<? super Maybe, ? extends Maybe> oldMaybeHook;
    private Function<? super Single, ? extends Single> oldSingleHook;
    private Function<? super Observable, ? extends Observable> oldObservableHook;
    private Function<? super Flowable, ? extends Flowable> oldFlowableHook;
    private Function<? super ConnectableFlowable, ? extends ConnectableFlowable> oldConnectableFlowableHook;
    private Function<? super ConnectableObservable, ? extends ConnectableObservable> oldConnectableObservableHook;
    private Function<? super ParallelFlowable, ? extends ParallelFlowable> oldParallelFlowableHook;

    public RxJava2Instrumentation(RunnableInstrumenter ... instrumenters) {
        this(Arrays.asList(instrumenters));
    }

    public RxJava2Instrumentation(List<RunnableInstrumenter> instrumenters) {
        this(instrumenters, Collections.emptyList());
    }

    @Inject
    public RxJava2Instrumentation(List<RunnableInstrumenter> instrumenters, List<ReactiveInstrumenter> reactiveInstrumenters) {
        this.instrumenters = instrumenters;
        this.reactiveInstrumenters = reactiveInstrumenters;
    }

    @PostConstruct
    void init() {
        if (CollectionUtils.isNotEmpty(this.reactiveInstrumenters)) {
            this.oldCompletableHook = RxJavaPlugins.getOnCompletableAssembly();
            this.oldMaybeHook = RxJavaPlugins.getOnMaybeAssembly();
            this.oldSingleHook = RxJavaPlugins.getOnSingleAssembly();
            this.oldObservableHook = RxJavaPlugins.getOnObservableAssembly();
            this.oldFlowableHook = RxJavaPlugins.getOnFlowableAssembly();
            this.oldConnectableFlowableHook = RxJavaPlugins.getOnConnectableFlowableAssembly();
            this.oldConnectableObservableHook = RxJavaPlugins.getOnConnectableObservableAssembly();
            this.oldParallelFlowableHook = RxJavaPlugins.getOnParallelAssembly();
            RxJavaPlugins.setOnCompletableAssembly(completable -> {
                Completable wrapped = RxInstrumentedWrappers.wrap((CompletableSource)completable, this.reactiveInstrumenters);
                if (this.oldCompletableHook != null) {
                    return (Completable)this.oldCompletableHook.apply((Object)wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnMaybeAssembly(maybe -> {
                Maybe wrapped = RxInstrumentedWrappers.wrap(maybe, this.reactiveInstrumenters);
                if (this.oldMaybeHook != null) {
                    return (Maybe)this.oldMaybeHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnSingleAssembly(single -> {
                Single wrapped = RxInstrumentedWrappers.wrap(single, this.reactiveInstrumenters);
                if (this.oldSingleHook != null) {
                    return (Single)this.oldSingleHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnObservableAssembly(observable -> {
                Observable wrapped = RxInstrumentedWrappers.wrap(observable, this.reactiveInstrumenters);
                if (this.oldObservableHook != null) {
                    return (Observable)this.oldObservableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnFlowableAssembly(flowable -> {
                Flowable wrapped = RxInstrumentedWrappers.wrap(flowable, this.reactiveInstrumenters);
                if (this.oldFlowableHook != null) {
                    return (Flowable)this.oldFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnConnectableFlowableAssembly(connectableFlowable -> {
                ConnectableFlowable wrapped = RxInstrumentedWrappers.wrap(connectableFlowable, this.reactiveInstrumenters);
                if (this.oldConnectableFlowableHook != null) {
                    return (ConnectableFlowable)this.oldConnectableFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnConnectableObservableAssembly(connectableObservable -> {
                ConnectableObservable wrapped = RxInstrumentedWrappers.wrap(connectableObservable, this.reactiveInstrumenters);
                if (this.oldConnectableObservableHook != null) {
                    return (ConnectableObservable)this.oldConnectableObservableHook.apply(connectableObservable);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnParallelAssembly(parallelFlowable -> {
                ParallelFlowable wrapped = RxInstrumentedWrappers.wrap(parallelFlowable, this.reactiveInstrumenters);
                if (this.oldParallelFlowableHook != null) {
                    return (ParallelFlowable)this.oldParallelFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
        }
        if (CollectionUtils.isNotEmpty(this.instrumenters)) {
            Function existing = RxJavaPlugins.getScheduleHandler();
            if (existing != null && !(existing instanceof RxJava2Instrumentation)) {
                RxJavaPlugins.setScheduleHandler(runnable -> this.apply((Runnable)existing.apply(runnable)));
            } else {
                RxJavaPlugins.setScheduleHandler((Function)this);
            }
        }
    }

    public Runnable apply(Runnable runnable) throws Exception {
        Runnable newRunnable = runnable;
        for (RunnableInstrumenter instrumenter : this.instrumenters) {
            newRunnable = instrumenter.instrument(newRunnable);
        }
        return newRunnable;
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            RxJavaPlugins.setOnCompletableAssembly(this.oldCompletableHook);
            RxJavaPlugins.setOnSingleAssembly(this.oldSingleHook);
            RxJavaPlugins.setOnMaybeAssembly(this.oldMaybeHook);
            RxJavaPlugins.setOnObservableAssembly(this.oldObservableHook);
            RxJavaPlugins.setOnFlowableAssembly(this.oldFlowableHook);
            RxJavaPlugins.setOnConnectableObservableAssembly(this.oldConnectableObservableHook);
            RxJavaPlugins.setOnConnectableFlowableAssembly(this.oldConnectableFlowableHook);
            RxJavaPlugins.setOnParallelAssembly(this.oldParallelFlowableHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

