/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedCompletableObserver
implements CompletableObserver,
RxInstrumentedComponent {
    private final CompletableObserver source;
    private final RxInstrumenterFactory instrumenterFactory;

    RxInstrumentedCompletableObserver(CompletableObserver source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenterFactory = instrumenterFactory;
    }

    public void onSubscribe(Disposable d) {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onSubscribe(d);
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onSubscribe(d);
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }

    public void onError(Throwable t) {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }

    public void onComplete() {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onComplete();
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }
}

