/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.observables.ConnectableObservable;

@Internal
final class RxInstrumentedConnectableObservable<T>
extends ConnectableObservable<T>
implements RxInstrumentedComponent {
    private final ConnectableObservable<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedConnectableObservable(ConnectableObservable<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Observer<? super T> o) {
        try {
            this.instrumenter.beforeInvocation();
            this.source.subscribe(o);
        }
        finally {
            this.instrumenter.afterInvocation();
        }
    }

    public void connect(Consumer<? super Disposable> connection) {
        try {
            this.instrumenter.beforeInvocation();
            this.source.connect(connection);
        }
        finally {
            this.instrumenter.afterInvocation();
        }
    }
}

