/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class RxInstrumentedSubscriber<T>
implements Subscriber<T>,
RxInstrumentedComponent {
    private final Subscriber<T> source;
    private final RxInstrumenterFactory instrumenterFactory;

    RxInstrumentedSubscriber(Subscriber<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenterFactory = instrumenterFactory;
    }

    public final void onSubscribe(Subscription s) {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onSubscribe(s);
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onSubscribe(s);
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }

    public void onNext(T t) {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onNext(t);
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onNext(t);
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }

    public void onError(Throwable t) {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }

    public void onComplete() {
        InvocationInstrumenter instrumenter = this.instrumenterFactory.create();
        if (instrumenter == null) {
            this.source.onComplete();
        } else {
            try {
                instrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                instrumenter.afterInvocation();
            }
        }
    }
}

