/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.health;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.discovery.CompositeDiscoveryClient;
import io.micronaut.discovery.DiscoveryClient;
import java.util.Collection;

@Introspected
public final class HeartbeatDiscoveryClientCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        ApplicationContext beanContext = (ApplicationContext)context.getBeanContext();
        Boolean enabled = beanContext.getProperty("micronaut.heartbeat.enabled", Boolean.class).orElse(Boolean.TRUE);
        if (enabled.booleanValue()) {
            return true;
        }
        Collection discoveryClients = beanContext.getBeanDefinitions(DiscoveryClient.class);
        boolean hasDiscovery = discoveryClients.stream().anyMatch(bean -> !CompositeDiscoveryClient.class.isAssignableFrom(bean.getBeanType()));
        if (hasDiscovery) {
            return true;
        }
        context.fail("Heartbeat not enabled since no Discovery client active");
        return false;
    }
}

