/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedMaybeObserver<T>
implements MaybeObserver<T>,
RxInstrumentedComponent {
    private final MaybeObserver<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedMaybeObserver(MaybeObserver<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        if (this.instrumenter == null) {
            this.source.onSubscribe(d);
        } else {
            try {
                this.instrumenter.beforeInvocation();
                this.source.onSubscribe(d);
            }
            finally {
                this.instrumenter.afterInvocation(false);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.instrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                this.instrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                this.instrumenter.afterInvocation(false);
            }
        }
    }

    public void onSuccess(T value) {
        if (this.instrumenter == null) {
            this.source.onSuccess(value);
        } else {
            try {
                this.instrumenter.beforeInvocation();
                this.source.onSuccess(value);
            }
            finally {
                this.instrumenter.afterInvocation(false);
            }
        }
    }

    public void onComplete() {
        if (this.instrumenter == null) {
            this.source.onComplete();
        } else {
            try {
                this.instrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                this.instrumenter.afterInvocation(false);
            }
        }
    }
}

