/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.SyncCache;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class AbstractMapBasedSyncCache<C extends Map<Object, Object>>
implements SyncCache<C> {
    private final ConversionService<?> conversionService;
    private final C nativeCache;

    public AbstractMapBasedSyncCache(ConversionService<?> conversionService, C nativeCache) {
        this.conversionService = conversionService;
        this.nativeCache = nativeCache;
    }

    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Override
    @Nonnull
    public <T> Optional<T> get(@Nonnull Object key, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Object value = this.nativeCache.get(key);
        if (value != null) {
            return this.conversionService.convert(value, ConversionContext.of(requiredType));
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(@Nonnull Object key, @Nonnull Argument<T> requiredType, @Nonnull Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Optional<T> existingValue = this.get(key, requiredType);
        if (existingValue.isPresent()) {
            return existingValue.get();
        }
        T value = supplier.get();
        this.put(key, value);
        return value;
    }

    @Override
    @Nonnull
    public <T> Optional<T> putIfAbsent(@Nonnull Object key, @Nonnull T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        T v = this.nativeCache.putIfAbsent((Object)key, value);
        Class<?> aClass = value.getClass();
        return this.conversionService.convert(v, aClass);
    }

    @Override
    @Nonnull
    public <T> T putIfAbsent(@Nonnull Object key, @Nonnull Supplier<T> value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        Object v = this.nativeCache.get(key);
        if (v == null) {
            return this.nativeCache.put((Object)key, value.get());
        }
        return (T)v;
    }

    @Override
    public void put(@Nonnull Object key, @Nonnull Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        this.nativeCache.put((Object)key, (Object)value);
    }

    @Override
    public void invalidate(@Nonnull Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        this.nativeCache.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.nativeCache.clear();
    }

    @Override
    public abstract String getName();

    @Override
    public C getNativeCache() {
        return this.nativeCache;
    }
}

