/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.Cache;
import io.micronaut.cache.DelegatingAsyncBlockingCache;
import io.micronaut.cache.DelegatingAsyncCache;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SyncCache<C>
extends Cache<C> {
    @Nonnull
    public <T> Optional<T> get(@Nonnull Object var1, @Nonnull Argument<T> var2);

    public <T> T get(@Nonnull Object var1, @Nonnull Argument<T> var2, @Nonnull Supplier<T> var3);

    @Nonnull
    public <T> Optional<T> putIfAbsent(@Nonnull Object var1, @Nonnull T var2);

    @Nonnull
    default public <T> T putIfAbsent(@Nonnull Object key, @Nonnull Supplier<T> value) {
        T val = value.get();
        return this.putIfAbsent(key, val).orElse(val);
    }

    public void put(@Nonnull Object var1, @Nonnull Object var2);

    public void invalidate(@Nonnull Object var1);

    public void invalidateAll();

    default public <T> T get(@Nonnull Object key, @Nonnull Class<T> requiredType, @Nonnull Supplier<T> supplier) {
        return this.get(key, Argument.of(requiredType), supplier);
    }

    @Nonnull
    default public <T> Optional<T> get(@Nonnull Object key, @Nonnull Class<T> requiredType) {
        return this.get(key, Argument.of(requiredType));
    }

    @Nullable
    default public ExecutorService getExecutorService() {
        return null;
    }

    @Nonnull
    default public AsyncCache<C> async() {
        ExecutorService executorService = this.getExecutorService();
        if (executorService == null) {
            return new DelegatingAsyncBlockingCache(this);
        }
        return new DelegatingAsyncCache(this, executorService);
    }
}

