/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.env;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.jackson.env.JsonPropertySourceLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class EnvJsonPropertySourceLoader
extends JsonPropertySourceLoader {
    public static final int POSITION = -50;
    private static final String SPRING_APPLICATION_JSON = "SPRING_APPLICATION_JSON";
    private static final String MICRONAUT_APPLICATION_JSON = "MICRONAUT_APPLICATION_JSON";

    public int getOrder() {
        return -50;
    }

    protected Optional<InputStream> readInput(ResourceLoader resourceLoader, String fileName) {
        String v;
        if (fileName.equals("application.json") && (v = this.getEnvValue()) != null) {
            String encoding = System.getProperty("file.encoding");
            Charset charset = encoding != null ? Charset.forName(encoding) : StandardCharsets.UTF_8;
            return Optional.of(new ByteArrayInputStream(v.getBytes(charset)));
        }
        return Optional.empty();
    }

    protected String getEnvValue() {
        String v = System.getenv(SPRING_APPLICATION_JSON);
        if (v == null) {
            v = System.getenv(MICRONAUT_APPLICATION_JSON);
        }
        return v;
    }
}

