/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.reactor;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Requires(classes={Flux.class, Schedulers.Factory.class})
@Context
@Internal
class ReactorInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(ReactorInstrumentation.class);

    ReactorInstrumentation() {
    }

    @PostConstruct
    void init(BeanContext beanContext, ThreadFactory threadFactory) {
        block3: {
            if (beanContext instanceof ApplicationContext) {
                try {
                    BeanDefinition beanDefinition = beanContext.getBeanDefinition(ExecutorService.class, Qualifiers.byName((String)"scheduled"));
                    Collection schedulerCreateListeners = beanContext.getBeansOfType(BeanCreatedEventListener.class, Qualifiers.byTypeArguments((Class[])new Class[]{ScheduledExecutorService.class}));
                    Schedulers.addExecutorServiceDecorator((String)"micronaut", (scheduler, scheduledExecutorService) -> {
                        for (BeanCreatedEventListener schedulerCreateListener : schedulerCreateListeners) {
                            Object newBean = schedulerCreateListener.onCreated(new BeanCreatedEvent(beanContext, beanDefinition, BeanIdentifier.of((String)("reactor-" + scheduler.getClass().getSimpleName())), scheduledExecutorService));
                            if (!(newBean instanceof ScheduledExecutorService)) {
                                throw new BeanContextException("Bean creation listener [" + schedulerCreateListener + "] should return ScheduledExecutorService, but returned " + newBean);
                            }
                            scheduledExecutorService = (ScheduledExecutorService)newBean;
                        }
                        return scheduledExecutorService;
                    });
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error("Could not instrument Reactor for Tracing: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @PreDestroy
    void removeInstrumentation() {
        Schedulers.removeExecutorServiceDecorator((String)"micronaut");
    }
}

