/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;

@Internal
final class RxInstrumentedObservable<T>
extends Observable<T>
implements RxInstrumentedComponent {
    private final ObservableSource<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedObservable(ObservableSource<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Observer<? super T> o) {
        try {
            this.instrumenter.beforeInvocation();
            this.source.subscribe(o);
        }
        finally {
            this.instrumenter.afterInvocation(false);
        }
    }
}

