/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;

@Internal
final class RxInstrumentedSingle<T>
extends Single<T>
implements RxInstrumentedComponent {
    private final SingleSource<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedSingle(SingleSource<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(SingleObserver<? super T> o) {
        try {
            this.instrumenter.beforeInvocation();
            this.source.subscribe(o);
        }
        finally {
            this.instrumenter.afterInvocation(false);
        }
    }
}

