/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;

@Singleton
@Internal
final class ThreadFactoryInstrumenter
implements BeanCreatedEventListener<ThreadFactory> {
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    public ThreadFactoryInstrumenter(List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this.invocationInstrumenterFactories = invocationInstrumenterFactories;
    }

    public ThreadFactory onCreated(BeanCreatedEvent<ThreadFactory> event) {
        if (this.invocationInstrumenterFactories.isEmpty()) {
            return (ThreadFactory)event.getBean();
        }
        ThreadFactory original = (ThreadFactory)event.getBean();
        return r -> original.newThread(this.instrument(r));
    }

    private Runnable instrument(Runnable runnable) {
        return InvocationInstrumenter.instrument(runnable, this.getInvocationInstrumenterList());
    }

    private List<InvocationInstrumenter> getInvocationInstrumenterList() {
        ArrayList<InvocationInstrumenter> instrumenters = new ArrayList<InvocationInstrumenter>(this.invocationInstrumenterFactories.size());
        for (InvocationInstrumenterFactory instrumenterFactory : this.invocationInstrumenterFactories) {
            InvocationInstrumenter instrumenter = instrumenterFactory.newInvocationInstrumenter();
            if (instrumenter == null) continue;
            instrumenters.add(instrumenter);
        }
        return instrumenters;
    }
}

