/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedObserver<T>
implements Observer<T>,
RxInstrumentedComponent {
    private final Observer<T> source;
    private final InvocationInstrumenter instrumenter;
    private boolean active;

    RxInstrumentedObserver(Observer<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        if (this.instrumenter == null || this.active) {
            this.source.onSubscribe(d);
        } else {
            try {
                this.active = true;
                this.instrumenter.beforeInvocation();
                this.source.onSubscribe(d);
            }
            finally {
                this.instrumenter.afterInvocation(false);
                this.active = false;
            }
        }
    }

    public void onNext(T t) {
        if (this.instrumenter == null || this.active) {
            this.source.onNext(t);
        } else {
            try {
                this.active = true;
                this.instrumenter.beforeInvocation();
                this.source.onNext(t);
            }
            finally {
                this.instrumenter.afterInvocation(false);
                this.active = false;
            }
        }
    }

    public void onError(Throwable t) {
        if (this.instrumenter == null || this.active) {
            this.source.onError(t);
        } else {
            try {
                this.active = true;
                this.instrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                this.instrumenter.afterInvocation(false);
                this.active = false;
            }
        }
    }

    public void onComplete() {
        if (this.instrumenter == null || this.active) {
            this.source.onComplete();
        } else {
            try {
                this.active = true;
                this.instrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                this.instrumenter.afterInvocation(false);
                this.active = false;
            }
        }
    }
}

