/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedCompletable;
import io.micronaut.reactive.rxjava2.RxInstrumentedCompletableObserver;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedConnectableFlowable;
import io.micronaut.reactive.rxjava2.RxInstrumentedConnectableObservable;
import io.micronaut.reactive.rxjava2.RxInstrumentedFlowable;
import io.micronaut.reactive.rxjava2.RxInstrumentedFlowableSubscriber;
import io.micronaut.reactive.rxjava2.RxInstrumentedMaybe;
import io.micronaut.reactive.rxjava2.RxInstrumentedMaybeObserver;
import io.micronaut.reactive.rxjava2.RxInstrumentedObservable;
import io.micronaut.reactive.rxjava2.RxInstrumentedObserver;
import io.micronaut.reactive.rxjava2.RxInstrumentedParallelFlowable;
import io.micronaut.reactive.rxjava2.RxInstrumentedSingle;
import io.micronaut.reactive.rxjava2.RxInstrumentedSingleObserver;
import io.micronaut.reactive.rxjava2.RxInstrumentedSubscriber;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedWrappers {
    RxInstrumentedWrappers() {
    }

    static <T> Subscriber<T> wrap(Subscriber<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter != null) {
            if (downstream instanceof FlowableSubscriber) {
                return new RxInstrumentedFlowableSubscriber<T>(downstream, instrumenterFactory);
            }
            return new RxInstrumentedSubscriber<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static Completable wrap(Completable source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedCompletable((CompletableSource)source, instumenter);
    }

    static <T> Maybe<T> wrap(Maybe<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedMaybe<T>(source, instumenter);
    }

    static <T> Single<T> wrap(Single<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedSingle<T>(source, instumenter);
    }

    static <T> Observable<T> wrap(Observable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedObservable<T>(source, instumenter);
    }

    static <T> ConnectableObservable<T> wrap(ConnectableObservable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableObservable<T>(source, instumenter);
    }

    static <T> Flowable<T> wrap(Flowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedFlowable<T>(source, instumenter);
    }

    static <T> ConnectableFlowable<T> wrap(ConnectableFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        InvocationInstrumenter instumenter = instrumenterFactory.create();
        if (instumenter == null) {
            return source;
        }
        return new RxInstrumentedConnectableFlowable<T>(source, instumenter);
    }

    static <T> ParallelFlowable<T> wrap(ParallelFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        if (source instanceof RxInstrumentedComponent) {
            return source;
        }
        return new RxInstrumentedParallelFlowable<T>(source, instrumenterFactory);
    }

    static <T> Observer<T> wrap(Observer<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> SingleObserver<T> wrap(SingleObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedSingleObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static <T> MaybeObserver<T> wrap(MaybeObserver<T> downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedMaybeObserver<T>(downstream, instrumenterFactory);
        }
        return downstream;
    }

    static CompletableObserver wrap(CompletableObserver downstream, RxInstrumenterFactory instrumenterFactory) {
        if (downstream instanceof RxInstrumentedComponent) {
            return downstream;
        }
        InvocationInstrumenter instrumenter = instrumenterFactory.create();
        if (instrumenter != null) {
            return new RxInstrumentedCompletableObserver(downstream, instrumenterFactory);
        }
        return downstream;
    }
}

