/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedCallable;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedRunnable;
import io.micronaut.scheduling.instrument.MultipleInvocationInstrumenter;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public interface InvocationInstrumenter {
    public static final InvocationInstrumenter NOOP = new InvocationInstrumenter(){

        @Override
        public void beforeInvocation() {
        }

        @Override
        public void afterInvocation(boolean cleanup) {
        }
    };

    public void beforeInvocation();

    public void afterInvocation(boolean var1);

    default public void afterInvocation() {
        this.afterInvocation(false);
    }

    @Nonnull
    public static InvocationInstrumenter combine(Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return NOOP;
        }
        if (invocationInstrumenters.size() == 1) {
            return invocationInstrumenters.iterator().next();
        }
        return new MultipleInvocationInstrumenter(invocationInstrumenters);
    }

    @Nonnull
    public static Runnable instrument(@Nonnull Runnable runnable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return runnable;
        }
        return InvocationInstrumenter.instrument(runnable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @Nonnull
    public static <V> Callable<V> instrument(@Nonnull Callable<V> callable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return callable;
        }
        return InvocationInstrumenter.instrument(callable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @Nonnull
    public static Runnable instrument(@Nonnull Runnable runnable, InvocationInstrumenter invocationInstrumenter) {
        if (runnable instanceof InvocationInstrumenterWrappedRunnable) {
            return runnable;
        }
        return new InvocationInstrumenterWrappedRunnable(invocationInstrumenter, runnable);
    }

    @Nonnull
    public static <V> Callable<V> instrument(@Nonnull Callable<V> callable, InvocationInstrumenter invocationInstrumenter) {
        if (callable instanceof InvocationInstrumenterWrappedCallable) {
            return callable;
        }
        return new InvocationInstrumenterWrappedCallable<V>(invocationInstrumenter, callable);
    }
}

