/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class MultipleInvocationInstrumenter
implements InvocationInstrumenter {
    private static final Logger LOG = LoggerFactory.getLogger(InvocationInstrumenter.class);
    private final Collection<InvocationInstrumenter> invocationInstrumenters;
    private final Deque<InvocationInstrumenter> executedInstrumenters;

    MultipleInvocationInstrumenter(Collection<InvocationInstrumenter> invocationInstrumenters) {
        this.invocationInstrumenters = invocationInstrumenters;
        this.executedInstrumenters = new ArrayDeque<InvocationInstrumenter>(invocationInstrumenters.size());
    }

    @Override
    public void beforeInvocation() {
        for (InvocationInstrumenter instrumenter : this.invocationInstrumenters) {
            instrumenter.beforeInvocation();
            this.executedInstrumenters.push(instrumenter);
        }
    }

    @Override
    public void afterInvocation(boolean cleanup) {
        while (!this.executedInstrumenters.isEmpty()) {
            try {
                this.executedInstrumenters.pop().afterInvocation(cleanup);
            }
            catch (Exception e) {
                LOG.warn("After instrumentation invocation error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

