/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.DefaultCacheConfiguration;
import io.micronaut.cache.DefaultSyncCache;
import io.micronaut.cache.DynamicCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.caffeine.cache.Cache;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.runtime.ApplicationConfiguration;
import javax.annotation.Nonnull;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(missingBeans={DynamicCacheManager.class}), @Requires(property="micronaut.cache.dynamic", notEquals="false")})
public class DefaultDynamicCacheManager
implements DynamicCacheManager<Cache> {
    private final ApplicationContext applicationContext;
    private final ConversionService<?> conversionService;
    private final ApplicationConfiguration applicationConfiguration;

    public DefaultDynamicCacheManager(ApplicationContext applicationContext, ConversionService<?> conversionService, ApplicationConfiguration applicationConfiguration) {
        this.applicationContext = applicationContext;
        this.conversionService = conversionService;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    @Nonnull
    public SyncCache<Cache> getCache(String name) {
        return new DefaultSyncCache(new DefaultCacheConfiguration(name, this.applicationConfiguration), this.applicationContext, this.conversionService);
    }
}

