/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedConnectableFlowable<T>
extends ConnectableFlowable<T>
implements RxInstrumentedComponent {
    private final ConnectableFlowable<T> source;
    private final InvocationInstrumenter instrumenter;
    private boolean active;

    RxInstrumentedConnectableFlowable(ConnectableFlowable<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.active) {
            this.source.subscribe(s);
            return;
        }
        try {
            this.active = true;
            this.instrumenter.beforeInvocation();
            this.source.subscribe(s);
        }
        finally {
            this.instrumenter.afterInvocation(false);
            this.active = false;
        }
    }

    public void connect(Consumer<? super Disposable> connection) {
        if (this.active) {
            this.source.connect(connection);
            return;
        }
        try {
            this.active = true;
            this.instrumenter.beforeInvocation();
            this.source.connect(connection);
        }
        finally {
            this.instrumenter.afterInvocation(false);
            this.active = false;
        }
    }
}

