/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedObserver<T>
implements Observer<T>,
RxInstrumentedComponent {
    private final Observer<T> source;
    private final InvocationInstrumenter onSubscribeInstrumenter;
    private final InvocationInstrumenter onResultInstrumenter;

    RxInstrumentedObserver(Observer<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.onSubscribeInstrumenter = instrumenterFactory.create();
        this.onResultInstrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        if (this.onSubscribeInstrumenter == null) {
            this.source.onSubscribe(d);
        } else {
            try {
                this.onSubscribeInstrumenter.beforeInvocation();
                this.source.onSubscribe(d);
            }
            finally {
                this.onSubscribeInstrumenter.afterInvocation();
            }
        }
    }

    public void onNext(T t) {
        if (this.onResultInstrumenter == null) {
            this.source.onNext(t);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onNext(t);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }

    public void onError(Throwable t) {
        if (this.onResultInstrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }

    public void onComplete() {
        if (this.onResultInstrumenter == null) {
            this.source.onComplete();
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }
}

