/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedSingleObserver<T>
implements SingleObserver<T>,
RxInstrumentedComponent {
    private final SingleObserver<T> source;
    private final InvocationInstrumenter onSubscribeInstrumenter;
    private final InvocationInstrumenter onResultInstrumenter;

    RxInstrumentedSingleObserver(SingleObserver<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.onSubscribeInstrumenter = instrumenterFactory.create();
        this.onResultInstrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        if (this.onSubscribeInstrumenter == null) {
            this.source.onSubscribe(d);
        } else {
            try {
                this.onSubscribeInstrumenter.beforeInvocation();
                this.source.onSubscribe(d);
            }
            finally {
                this.onSubscribeInstrumenter.afterInvocation();
            }
        }
    }

    public void onError(Throwable t) {
        if (this.onResultInstrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }

    public void onSuccess(T value) {
        if (this.onResultInstrumenter == null) {
            this.source.onSuccess(value);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onSuccess(value);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }
}

