/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class RxInstrumentedSubscriber<T>
implements Subscriber<T>,
RxInstrumentedComponent {
    private final Subscriber<T> source;
    private final InvocationInstrumenter onSubscribeInstrumenter;
    private final InvocationInstrumenter onResultInstrumenter;

    RxInstrumentedSubscriber(Subscriber<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.onSubscribeInstrumenter = instrumenterFactory.create();
        this.onResultInstrumenter = instrumenterFactory.create();
    }

    public final void onSubscribe(Subscription s) {
        if (this.onSubscribeInstrumenter == null) {
            this.source.onSubscribe(s);
        } else {
            try {
                this.onSubscribeInstrumenter.beforeInvocation();
                this.source.onSubscribe(s);
            }
            finally {
                this.onSubscribeInstrumenter.afterInvocation();
            }
        }
    }

    public void onNext(T t) {
        if (this.onResultInstrumenter == null) {
            this.source.onNext(t);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onNext(t);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }

    public void onError(Throwable t) {
        if (this.onResultInstrumenter == null) {
            this.source.onError(t);
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onError(t);
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }

    public void onComplete() {
        if (this.onResultInstrumenter == null) {
            this.source.onComplete();
        } else {
            try {
                this.onResultInstrumenter.beforeInvocation();
                this.source.onComplete();
            }
            finally {
                this.onResultInstrumenter.afterInvocation();
            }
        }
    }
}

