/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonBlocking;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpResponse;
import io.micronaut.inject.MethodReference;
import io.micronaut.scheduling.executor.ExecutorSelector;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class DefaultExecutorSelector
implements ExecutorSelector {
    private final ExecutorService ioExecutor;

    protected DefaultExecutorSelector(@Named(value="io") ExecutorService ioExecutor) {
        this.ioExecutor = ioExecutor;
    }

    @Override
    public Optional<ExecutorService> select(MethodReference method) {
        Class argumentType;
        Optional generic;
        if (method.hasStereotype(NonBlocking.class)) {
            return Optional.empty();
        }
        if (method.hasStereotype(Blocking.class)) {
            return Optional.of(this.ioExecutor);
        }
        Class returnType = method.getReturnType().getType();
        if (this.isNonBlocking(returnType)) {
            return Optional.empty();
        }
        if (HttpResponse.class.isAssignableFrom(returnType) && (generic = method.getReturnType().getFirstTypeVariable()).isPresent() && this.isNonBlocking(argumentType = ((Argument)generic.get()).getType())) {
            return Optional.empty();
        }
        return Optional.of(this.ioExecutor);
    }

    private boolean isNonBlocking(Class type) {
        return Publishers.isConvertibleToPublisher((Class)type) || CompletionStage.class.isAssignableFrom(type);
    }
}

