/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@Factory
public class ExecutorFactory {
    private final ThreadFactory threadFactory;

    public ExecutorFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @EachBean(value=ExecutorConfiguration.class)
    @Bean(preDestroy="shutdown")
    public ExecutorService executorService(ExecutorConfiguration executorConfiguration) {
        ExecutorType executorType = executorConfiguration.getType();
        switch (executorType) {
            case FIXED: {
                return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(factory -> Executors.newFixedThreadPool(executorConfiguration.getNumberOfThreads(), factory)).orElse(Executors.newFixedThreadPool(executorConfiguration.getNumberOfThreads(), this.threadFactory));
            }
            case CACHED: {
                return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(Executors::newCachedThreadPool).orElse(Executors.newCachedThreadPool(this.threadFactory));
            }
            case SCHEDULED: {
                return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(factory -> Executors.newScheduledThreadPool(executorConfiguration.getCorePoolSize(), factory)).orElse(Executors.newScheduledThreadPool(executorConfiguration.getCorePoolSize(), this.threadFactory));
            }
            case WORK_STEALING: {
                return Executors.newWorkStealingPool(executorConfiguration.getParallelism());
            }
        }
        throw new IllegalStateException("Could not create Executor service for enum value: " + (Object)((Object)executorType));
    }
}

