/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;

@Singleton
@Internal
final class ExecutorServiceInstrumenter
implements BeanCreatedEventListener<ExecutorService> {
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    public ExecutorServiceInstrumenter(List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this.invocationInstrumenterFactories = invocationInstrumenterFactories;
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        if (this.invocationInstrumenterFactories.isEmpty()) {
            return (ExecutorService)event.getBean();
        }
        Class beanType = event.getBeanDefinition().getBeanType();
        if (beanType == ExecutorService.class) {
            final ExecutorService executorService = (ExecutorService)event.getBean();
            if (executorService instanceof ScheduledExecutorService) {
                return new InstrumentedScheduledExecutorService(){

                    @Override
                    public ScheduledExecutorService getTarget() {
                        return (ScheduledExecutorService)executorService;
                    }

                    @Override
                    public <T> Callable<T> instrument(Callable<T> task) {
                        return ExecutorServiceInstrumenter.this.instrumentInvocation(task);
                    }

                    @Override
                    public Runnable instrument(Runnable command) {
                        return ExecutorServiceInstrumenter.this.instrumentInvocation(command);
                    }
                };
            }
            return new InstrumentedExecutorService(){

                @Override
                public ExecutorService getTarget() {
                    return executorService;
                }

                @Override
                public <T> Callable<T> instrument(Callable<T> task) {
                    return ExecutorServiceInstrumenter.this.instrumentInvocation(task);
                }

                @Override
                public Runnable instrument(Runnable command) {
                    return ExecutorServiceInstrumenter.this.instrumentInvocation(command);
                }
            };
        }
        return (ExecutorService)event.getBean();
    }

    private Runnable instrumentInvocation(Runnable runnable) {
        return InvocationInstrumenter.instrument(runnable, this.getInvocationInstrumenter());
    }

    private <V> Callable<V> instrumentInvocation(Callable<V> callable) {
        return InvocationInstrumenter.instrument(callable, this.getInvocationInstrumenter());
    }

    private List<InvocationInstrumenter> getInvocationInstrumenter() {
        ArrayList<InvocationInstrumenter> instrumenters = new ArrayList<InvocationInstrumenter>(this.invocationInstrumenterFactories.size());
        for (InvocationInstrumenterFactory instrumenterFactory : this.invocationInstrumenterFactories) {
            InvocationInstrumenter instrumenter = instrumenterFactory.newInvocationInstrumenter();
            if (instrumenter == null) continue;
            instrumenters.add(instrumenter);
        }
        return instrumenters;
    }
}

