/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class MultipleInvocationInstrumenter
implements InvocationInstrumenter {
    private static final Logger LOG = LoggerFactory.getLogger(InvocationInstrumenter.class);
    private final List<InvocationInstrumenter> invocationInstrumenters;

    MultipleInvocationInstrumenter(Collection<InvocationInstrumenter> invocationInstrumenters) {
        this.invocationInstrumenters = new ArrayList<InvocationInstrumenter>(invocationInstrumenters);
    }

    @Override
    public void beforeInvocation() {
        for (InvocationInstrumenter instrumenter : this.invocationInstrumenters) {
            try {
                instrumenter.beforeInvocation();
            }
            catch (Exception e) {
                LOG.warn("Before instrumentation invocation error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public void afterInvocation(boolean cleanup) {
        ListIterator<InvocationInstrumenter> iterator = this.invocationInstrumenters.listIterator(this.invocationInstrumenters.size());
        while (iterator.hasPrevious()) {
            try {
                iterator.previous().afterInvocation(cleanup);
            }
            catch (Exception e) {
                LOG.warn("After instrumentation invocation error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

