/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.aws;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.io.IOUtils;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolverUtils;
import io.micronaut.discovery.cloud.NetworkInterface;
import io.micronaut.discovery.cloud.aws.AmazonEC2InstanceMetadata;
import io.micronaut.discovery.cloud.aws.AmazonMetadataConfiguration;
import io.micronaut.discovery.cloud.aws.AmazonNetworkInterface;
import io.micronaut.discovery.cloud.aws.EC2MetadataKeys;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"ec2"})
public class AmazonComputeInstanceMetadataResolver
implements ComputeInstanceMetadataResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonComputeInstanceMetadataResolver.class);
    private static final int READ_TIMEOUT_IN_MILLS = 5000;
    private static final int CONNECTION_TIMEOUT_IN_MILLS = 5000;
    private static final Pattern DRIVE_LETTER_PATTERN = Pattern.compile("^\\/*[a-zA-z]:.*$");
    private final ObjectMapper objectMapper;
    private final AmazonMetadataConfiguration configuration;
    private AmazonEC2InstanceMetadata cachedMetadata;

    @Inject
    public AmazonComputeInstanceMetadataResolver(ObjectMapper objectMapper, AmazonMetadataConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public AmazonComputeInstanceMetadataResolver() {
        this.objectMapper = new ObjectMapper();
        this.configuration = new AmazonMetadataConfiguration();
    }

    @Override
    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        if (!this.configuration.isEnabled()) {
            return Optional.empty();
        }
        if (this.cachedMetadata != null) {
            this.cachedMetadata.setCached(true);
            return Optional.of(this.cachedMetadata);
        }
        AmazonEC2InstanceMetadata ec2InstanceMetadata = new AmazonEC2InstanceMetadata();
        try {
            String ec2InstanceMetadataURL;
            block13: {
                block12: {
                    String ec2InstanceIdentityDocURL = this.configuration.getInstanceDocumentUrl();
                    ec2InstanceMetadataURL = this.configuration.getMetadataUrl();
                    JsonNode metadataJson = ComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(ec2InstanceIdentityDocURL), 5000, 5000, this.objectMapper, new HashMap<String, String>());
                    if (metadataJson != null) {
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, EC2MetadataKeys.instanceId.name()).ifPresent(ec2InstanceMetadata::setInstanceId);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, EC2MetadataKeys.accountId.name()).ifPresent(ec2InstanceMetadata::setAccount);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, EC2MetadataKeys.availabilityZone.name()).ifPresent(ec2InstanceMetadata::setAvailabilityZone);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, EC2MetadataKeys.instanceType.name()).ifPresent(ec2InstanceMetadata::setMachineType);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, EC2MetadataKeys.region.name()).ifPresent(ec2InstanceMetadata::setRegion);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, "privateIp").ifPresent(ec2InstanceMetadata::setPrivateIpV4);
                        ComputeInstanceMetadataResolverUtils.stringValue(metadataJson, "imageId").ifPresent(ec2InstanceMetadata::setImageId);
                    }
                    try {
                        ec2InstanceMetadata.setLocalHostname(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + EC2MetadataKeys.localHostname.getName()), 5000, 5000));
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block12;
                        LOG.error("Error getting local hostname from url:" + ec2InstanceMetadataURL + EC2MetadataKeys.localHostname.name(), (Throwable)e);
                    }
                }
                try {
                    ec2InstanceMetadata.setPublicHostname(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.getName()), 5000, 5000));
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block13;
                    LOG.error("error getting public host name from:" + ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.name(), (Throwable)e);
                }
            }
            try {
                String macAddress = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + (Object)((Object)EC2MetadataKeys.mac)), 5000, 5000);
                AmazonNetworkInterface networkInterface = new AmazonNetworkInterface();
                networkInterface.setMac(macAddress);
                String vpcId = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/vpc-id/"), 5000, 5000);
                String subnetId = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/subnet-id/"), 5000, 5000);
                networkInterface.setNetwork(subnetId);
                ec2InstanceMetadata.setPublicIpV4(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/public-ipv4s/"), 5000, 5000));
                ec2InstanceMetadata.setPrivateIpV4(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/local-ipv4s/"), 5000, 5000));
                networkInterface.setIpv4(ec2InstanceMetadata.getPrivateIpV4());
                networkInterface.setId(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/interface-id/"), 5000, 5000));
                networkInterface.setGateway(vpcId);
                ec2InstanceMetadata.setInterfaces(new ArrayList<NetworkInterface>());
                ec2InstanceMetadata.getInterfaces().add(networkInterface);
            }
            catch (IOException e) {
                LOG.error("error getting public host name from:" + ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.getName(), (Throwable)e);
            }
            Map metadata = (Map)this.objectMapper.convertValue((Object)ec2InstanceMetadata, Map.class);
            ComputeInstanceMetadataResolverUtils.populateMetadata(ec2InstanceMetadata, metadata);
            if (LOG.isDebugEnabled()) {
                LOG.debug("EC2 Metadata found:" + ec2InstanceMetadata.getMetadata().toString());
            }
        }
        catch (IOException e) {
            LOG.error("Error reading ec2 metadata url", (Throwable)e);
        }
        this.cachedMetadata = ec2InstanceMetadata;
        return Optional.of(ec2InstanceMetadata);
    }

    private String readEc2MetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs) throws IOException {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            url = this.rewriteUrl(url);
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                String string = IOUtils.readText((BufferedReader)in);
                return string;
            }
        }
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        int responseCode = uc.getResponseCode();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));){
            String string = IOUtils.readText((BufferedReader)in);
            return string;
        }
    }

    private URL rewriteUrl(URL url) throws MalformedURLException {
        String path = url.getPath();
        if (path.indexOf(58) != -1) {
            boolean driveLetterFound = DRIVE_LETTER_PATTERN.matcher(path).matches();
            path = path.replace(':', '_');
            if (driveLetterFound) {
                path = path.replaceFirst("_", ":");
            }
            url = new URL(url.getProtocol(), url.getHost(), path);
        }
        return url;
    }
}

