/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.health;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.discovery.CompositeDiscoveryClient;

@Introspected
public final class HeartbeatDiscoveryClientCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        boolean hasDiscovery;
        ApplicationContext beanContext = (ApplicationContext)context.getBeanContext();
        CompositeDiscoveryClient compositeDiscoveryClient = (CompositeDiscoveryClient)beanContext.getBean(CompositeDiscoveryClient.class);
        boolean bl = hasDiscovery = compositeDiscoveryClient.getDiscoveryClients().length > 0;
        if (hasDiscovery) {
            return true;
        }
        Boolean enabled = beanContext.getProperty("micronaut.heartbeat.enabled", ArgumentConversionContext.BOOLEAN).orElse(Boolean.FALSE);
        if (!enabled.booleanValue()) {
            context.fail("Heartbeat not enabled since no Discovery client active");
        }
        return enabled;
    }
}

