/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.modules;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.hateoas.Resource;
import io.micronaut.jackson.JacksonConfiguration;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@Requires(property="jackson.bean-introspection-module", value="true", defaultValue="true")
public class BeanIntrospectionModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(BeanIntrospectionModule.class);

    public BeanIntrospectionModule() {
        this.setDeserializerModifier(new BeanIntrospectionDeserializerModifier());
        this.setSerializerModifier(new BeanIntrospectionSerializerModifier());
    }

    private JavaType newType(Argument<?> argument, TypeFactory typeFactory) {
        return JacksonConfiguration.constructType(argument, typeFactory);
    }

    private PropertyMetadata newPropertyMetadata(Argument<?> argument, AnnotationMetadata annotationMetadata) {
        Boolean required = argument.isNonNull() || annotationMetadata.booleanValue(JsonProperty.class, "required").orElse(false) != false;
        int index = annotationMetadata.intValue(JsonProperty.class, "index").orElse(-1);
        return PropertyMetadata.construct((Boolean)required, (String)annotationMetadata.stringValue(JsonPropertyDescription.class).orElse(null), (Integer)(index > -1 ? Integer.valueOf(index) : null), (String)annotationMetadata.stringValue(JsonProperty.class, "defaultValue").orElse(null));
    }

    private static class BeanIntrospectionSetter
    extends SettableBeanProperty.Delegating {
        final BeanProperty beanProperty;

        BeanIntrospectionSetter(SettableBeanProperty methodProperty, BeanProperty beanProperty) {
            super(methodProperty);
            this.beanProperty = beanProperty;
        }

        protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
            return new BeanIntrospectionSetter(d, this.beanProperty);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) {
            this.beanProperty.set(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) {
            this.beanProperty.set(instance, value);
            return null;
        }
    }

    private class BeanIntrospectionPropertyWriter
    extends BeanPropertyWriter {
        protected final Class<?>[] _views;
        final BeanProperty<Object, Object> beanProperty;
        final SerializableString fastName;
        private final JavaType type;
        private final boolean shouldSuppressNulls;

        BeanIntrospectionPropertyWriter(BeanPropertyWriter src, BeanProperty<Object, Object> introspection, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            this(src.getSerializedName(), src, introspection, ser, typeFactory, views);
        }

        BeanIntrospectionPropertyWriter(SerializableString name, BeanPropertyWriter src, BeanProperty<Object, Object> introspection, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            super(src);
            this._serializer = ser != null ? ser : src.getSerializer();
            this.beanProperty = introspection;
            this.fastName = name;
            this._views = views;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = ser == null ? PropertySerializerMap.emptyForProperties() : null;
            this.shouldSuppressNulls = this.shouldSuppressNulls(this._suppressNulls);
        }

        BeanIntrospectionPropertyWriter(String name, BeanProperty<Object, Object> introspection, TypeFactory typeFactory) {
            this.beanProperty = introspection;
            this.fastName = new SerializedString(name);
            this._views = null;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            this.shouldSuppressNulls = this.shouldSuppressNulls(this._suppressNulls);
        }

        public String getName() {
            return this.fastName.getValue();
        }

        public boolean willSuppressNulls() {
            return this.shouldSuppressNulls || super.willSuppressNulls();
        }

        public PropertyName getFullName() {
            return new PropertyName(this.getName());
        }

        public void fixAccess(SerializationConfig config) {
        }

        public JavaType getType() {
            return this.type;
        }

        private boolean inView(Class<?> activeView) {
            if (activeView == null || this._views == null) {
                return true;
            }
            int len = this._views.length;
            for (int i = 0; i < len; ++i) {
                if (!this._views[i].isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }

        private boolean shouldSuppressNulls(boolean defaultSupressNull) {
            JsonInclude.Include include = this.beanProperty.enumValue(JsonInclude.class, JsonInclude.Include.class).orElse(null);
            if (include == null) {
                include = this.beanProperty.getDeclaringBean().enumValue(JsonInclude.class, JsonInclude.Include.class).orElse(null);
            }
            if (include != null) {
                switch (include) {
                    case ALWAYS: {
                        return false;
                    }
                    case NON_NULL: 
                    case NON_ABSENT: 
                    case NON_EMPTY: {
                        return true;
                    }
                }
                return defaultSupressNull;
            }
            return defaultSupressNull;
        }

        public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    gen.writeFieldName(this.fastName);
                    this._nullSerializer.serialize(null, gen, prov);
                } else if (!willSuppressNulls) {
                    gen.writeFieldName(this.fastName);
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
                return;
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            gen.writeFieldName(this.fastName);
            if (this._typeSerializer == null) {
                ser.serialize(value, gen, prov);
            } else {
                ser.serializeWithType(value, gen, prov, this._typeSerializer);
            }
        }

        public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    this._nullSerializer.serialize(null, gen, prov);
                } else if (willSuppressNulls) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                } else {
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null) {
                if (MARKER_FOR_EMPTY == this._suppressableValue) {
                    if (ser.isEmpty(prov, value)) {
                        this.serializeAsPlaceholder(bean, gen, prov);
                        return;
                    }
                } else if (this._suppressableValue.equals(value)) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                    return;
                }
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            if (this._typeSerializer == null) {
                ser.serialize(value, gen, prov);
            } else {
                ser.serializeWithType(value, gen, prov, this._typeSerializer);
            }
        }
    }

    private class VirtualSetter
    extends SettableBeanProperty {
        final BeanProperty beanProperty;
        final TypeResolutionContext typeResolutionContext;

        VirtualSetter(TypeResolutionContext typeResolutionContext, TypeFactory typeFactory, BeanProperty beanProperty) {
            super(new PropertyName(beanProperty.getName()), BeanIntrospectionModule.this.newType(beanProperty.asArgument(), typeFactory), BeanIntrospectionModule.this.newPropertyMetadata(beanProperty.asArgument(), beanProperty.getAnnotationMetadata()), null);
            this.beanProperty = beanProperty;
            this.typeResolutionContext = typeResolutionContext;
        }

        VirtualSetter(PropertyName propertyName, VirtualSetter src) {
            super(propertyName, src._type, src._metadata, src._valueDeserializer);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(NullValueProvider nullValueProvider, VirtualSetter src) {
            super((SettableBeanProperty)src, src._valueDeserializer, nullValueProvider);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(JsonDeserializer<Object> deser, VirtualSetter src) {
            super(src._propName, src._type, src._metadata, deser);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
            return new VirtualSetter(deser, this);
        }

        public SettableBeanProperty withName(PropertyName newName) {
            return new VirtualSetter(newName, this);
        }

        public SettableBeanProperty withNullProvider(NullValueProvider nva) {
            return new VirtualSetter(nva, this);
        }

        public AnnotatedMember getMember() {
            return new VirtualAnnotatedMember(this.typeResolutionContext, this.beanProperty.getDeclaringType(), this._propName.getSimpleName(), this._type){

                public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
                    return Arrays.stream(annoClasses).anyMatch(arg_0 -> ((BeanProperty)VirtualSetter.this.beanProperty).hasAnnotation(arg_0));
                }
            };
        }

        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A)this.beanProperty.getAnnotationMetadata().synthesize(acls);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) throws IOException {
            this.beanProperty.set(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) throws IOException {
            this.beanProperty.set(instance, value);
            return null;
        }
    }

    private class BeanIntrospectionDeserializerModifier
    extends BeanDeserializerModifier {
        private BeanIntrospectionDeserializerModifier() {
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, final BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            final Class beanClass = beanDesc.getBeanClass();
            final BeanIntrospection introspection = BeanIntrospector.SHARED.findIntrospection(beanClass).orElse(null);
            if (introspection == null) {
                return builder;
            }
            Iterator properties = builder.getProperties();
            if (!properties.hasNext() && introspection.getPropertyNames().length > 0) {
                for (BeanProperty beanProperty : introspection.getBeanProperties()) {
                    builder.addOrReplaceProperty((SettableBeanProperty)new VirtualSetter((TypeResolutionContext)beanDesc.getClassInfo(), config.getTypeFactory(), beanProperty), true);
                }
            } else {
                while (properties.hasNext()) {
                    BeanProperty bp;
                    SettableBeanProperty settableBeanProperty = (SettableBeanProperty)properties.next();
                    if (!(settableBeanProperty instanceof MethodProperty)) continue;
                    MethodProperty methodProperty = (MethodProperty)settableBeanProperty;
                    Optional beanProperty = introspection.getProperty(settableBeanProperty.getName());
                    if (!beanProperty.isPresent() || (bp = (BeanProperty)beanProperty.get()).isReadOnly()) continue;
                    BeanIntrospectionSetter newProperty = new BeanIntrospectionSetter((SettableBeanProperty)methodProperty, bp);
                    builder.addOrReplaceProperty((SettableBeanProperty)newProperty, true);
                }
            }
            final Argument[] constructorArguments = introspection.getConstructorArguments();
            final TypeFactory typeFactory = config.getTypeFactory();
            builder.setValueInstantiator((ValueInstantiator)new StdValueInstantiator(config, typeFactory.constructType((Type)beanClass)){

                public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                    SettableBeanProperty[] props = new SettableBeanProperty[constructorArguments.length];
                    for (int i = 0; i < constructorArguments.length; ++i) {
                        TypeDeserializer typeDeserializer;
                        final Argument argument = constructorArguments[i];
                        final JavaType javaType = BeanIntrospectionModule.this.newType(argument, typeFactory);
                        final AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
                        PropertyMetadata propertyMetadata = BeanIntrospectionModule.this.newPropertyMetadata(argument, annotationMetadata);
                        String simpleName = annotationMetadata.stringValue(JsonProperty.class).orElse(argument.getName());
                        try {
                            typeDeserializer = config.findTypeDeserializer(javaType);
                        }
                        catch (JsonMappingException e) {
                            typeDeserializer = null;
                        }
                        props[i] = new CreatorProperty(PropertyName.construct((String)simpleName), javaType, null, typeDeserializer, null, null, i, null, propertyMetadata){
                            private final BeanProperty<Object, Object> property;
                            {
                                super(x0, x1, x2, x3, x4, x5, x6, x7, x8);
                                this.property = introspection.getProperty(argument.getName()).orElse(null);
                            }

                            public <A extends Annotation> A getAnnotation(Class<A> acls) {
                                return (A)annotationMetadata.synthesize(acls);
                            }

                            public AnnotatedMember getMember() {
                                return new VirtualAnnotatedMember((TypeResolutionContext)beanDesc.getClassInfo(), beanClass, argument.getName(), javaType){

                                    public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
                                        return Arrays.stream(annoClasses).anyMatch(arg_0 -> ((AnnotationMetadata)annotationMetadata).hasAnnotation(arg_0));
                                    }
                                };
                            }

                            public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                if (this.property != null) {
                                    this.property.set(instance, this.deserialize(p, ctxt));
                                }
                            }

                            public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                if (this.property != null) {
                                    this.property.set(instance, this.deserialize(p, ctxt));
                                }
                                return null;
                            }

                            public void set(Object instance, Object value) {
                                if (this.property != null) {
                                    this.property.set(instance, value);
                                }
                            }

                            public Object setAndReturn(Object instance, Object value) throws IOException {
                                if (this.property != null) {
                                    this.property.set(instance, value);
                                }
                                return null;
                            }
                        };
                    }
                    return props;
                }

                public boolean canInstantiate() {
                    return true;
                }

                public boolean canCreateUsingDefault() {
                    return constructorArguments.length == 0;
                }

                public boolean canCreateFromObjectWith() {
                    return constructorArguments.length > 0;
                }

                public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
                    return introspection.instantiate();
                }

                public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                    return introspection.instantiate(false, args);
                }
            });
            return builder;
        }
    }

    private class BeanIntrospectionSerializerModifier
    extends BeanSerializerModifier {
        private BeanIntrospectionSerializerModifier() {
        }

        public BeanSerializerBuilder updateBuilder(final SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            final Class beanClass = beanDesc.getBeanClass();
            boolean isResource = Resource.class.isAssignableFrom(beanDesc.getBeanClass());
            BeanIntrospection introspection = BeanIntrospector.SHARED.findIntrospection(beanClass).orElse(null);
            if (introspection == null) {
                return super.updateBuilder(config, beanDesc, builder);
            }
            BeanSerializerBuilder newBuilder = new BeanSerializerBuilder(beanDesc){

                public JsonSerializer<?> build() {
                    this.setConfig(config);
                    try {
                        return super.build();
                    }
                    catch (RuntimeException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error building bean serializer for type [" + beanClass + "]: " + e.getMessage(), (Throwable)e);
                        }
                        throw e;
                    }
                }
            };
            List properties = builder.getProperties();
            Collection beanProperties = introspection.getBeanProperties();
            if (CollectionUtils.isEmpty((Collection)properties) && CollectionUtils.isNotEmpty((Collection)beanProperties)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean {} has no properties, while BeanIntrospection does. Recreating from introspection.", (Object)beanClass);
                }
                ArrayList<BeanIntrospectionPropertyWriter> newProperties = new ArrayList<BeanIntrospectionPropertyWriter>(beanProperties.size());
                for (BeanProperty beanProperty : beanProperties) {
                    String n;
                    String propertyName = isResource ? ("embedded".equals(n = beanProperty.getName()) ? "_embedded" : ("links".equals(n) ? "_links" : beanProperty.stringValue(JsonProperty.class).orElse(beanProperty.getName()))) : beanProperty.stringValue(JsonProperty.class).orElse(beanProperty.getName());
                    BeanIntrospectionPropertyWriter writer = new BeanIntrospectionPropertyWriter(propertyName, (BeanProperty<Object, Object>)beanProperty, config.getTypeFactory());
                    newProperties.add(writer);
                }
                newBuilder.setProperties(newProperties);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating {} properties with BeanIntrospection data for type: {}", (Object)properties.size(), (Object)beanClass);
                }
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>(properties);
                LinkedHashMap named = new LinkedHashMap(properties.size());
                for (BeanProperty beanProperty : beanProperties) {
                    Optional n = beanProperty.stringValue(JsonProperty.class);
                    n.ifPresent(s -> named.put(s, beanProperty));
                }
                for (int i = 0; i < properties.size(); ++i) {
                    BeanPropertyWriter existing = (BeanPropertyWriter)properties.get(i);
                    String existingName = existing.getName();
                    Optional property = named.containsKey(existingName) ? Optional.of(named.get(existingName)) : introspection.getProperty(existingName);
                    if (property.isPresent()) {
                        BeanProperty beanProperty = (BeanProperty)property.get();
                        if (isResource) {
                            if ("embedded".equals(beanProperty.getName())) {
                                newProperties.set(i, new BeanIntrospectionPropertyWriter((SerializableString)new SerializedString("_embedded"), existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                                continue;
                            }
                            if ("links".equals(beanProperty.getName())) {
                                newProperties.set(i, new BeanIntrospectionPropertyWriter((SerializableString)new SerializedString("_links"), existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                                continue;
                            }
                        }
                        newProperties.set(i, new BeanIntrospectionPropertyWriter(existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                        continue;
                    }
                    newProperties.set(i, existing);
                }
                newBuilder.setProperties(newProperties);
            }
            return newBuilder;
        }
    }
}

