/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JacksonObjectSerializer
implements ObjectSerializer {
    private final ObjectMapper objectMapper;

    public JacksonObjectSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Optional<byte[]> serialize(Object object) throws SerializationException {
        try {
            return Optional.ofNullable(this.objectMapper.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error serializing object to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public void serialize(Object object, OutputStream outputStream) throws SerializationException {
        try {
            this.objectMapper.writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new SerializationException("Error serializing object to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(byte[] bytes, Class<T> requiredType) throws SerializationException {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(bytes, requiredType));
        }
        catch (IOException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> Optional<T> deserialize(InputStream inputStream, Class<T> requiredType) throws SerializationException {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(inputStream, requiredType));
        }
        catch (IOException e) {
            throw new SerializationException("Error deserializing object from JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

