/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.RetryStateBuilder;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.retry.intercept.SimpleRetry;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class AnnotationRetryStateBuilder
implements RetryStateBuilder {
    private static final String ATTEMPTS = "attempts";
    private static final String MULTIPLIER = "multiplier";
    private static final String DELAY = "delay";
    private static final String MAX_DELAY = "maxDelay";
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";
    private static final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final AnnotationMetadata annotationMetadata;

    AnnotationRetryStateBuilder(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    @Override
    public RetryState build() {
        AnnotationValue retry = (AnnotationValue)this.annotationMetadata.findAnnotation(Retryable.class).orElseThrow(() -> new IllegalStateException("Missing @Retryable annotation"));
        int attempts = retry.get((CharSequence)ATTEMPTS, Integer.class).orElse(3);
        Duration delay = retry.get((CharSequence)DELAY, Duration.class).orElse(Duration.ofSeconds(1L));
        List<Class<? extends Throwable>> includes = this.resolveIncludes((AnnotationValue<Retryable>)retry, INCLUDES);
        List<Class<? extends Throwable>> excludes = this.resolveIncludes((AnnotationValue<Retryable>)retry, EXCLUDES);
        return new SimpleRetry(attempts, retry.get((CharSequence)MULTIPLIER, Double.class).orElse(0.0), delay, retry.get((CharSequence)MAX_DELAY, Duration.class).orElse(null), includes, excludes);
    }

    private List<Class<? extends Throwable>> resolveIncludes(AnnotationValue<Retryable> retry, String includes) {
        Class[] values = retry.classValues(includes);
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}

