/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.intercept.MutableRetryState;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class SimpleRetry
implements RetryState,
MutableRetryState {
    private final int maxAttempts;
    private final double multiplier;
    private final Duration delay;
    private final Duration maxDelay;
    private final boolean hasIncludes;
    private final boolean hasExcludes;
    private AtomicInteger attemptNumber = new AtomicInteger(0);
    private AtomicLong overallDelay = new AtomicLong(0L);
    private final List<Class<? extends Throwable>> includes;
    private final List<Class<? extends Throwable>> excludes;

    SimpleRetry(int maxAttempts, double multiplier, Duration delay, Duration maxDelay, List<Class<? extends Throwable>> includes, List<Class<? extends Throwable>> excludes) {
        this.maxAttempts = maxAttempts;
        this.multiplier = multiplier;
        this.delay = delay;
        this.maxDelay = maxDelay;
        this.includes = includes == null ? Collections.emptyList() : includes;
        this.excludes = excludes == null ? Collections.emptyList() : excludes;
        this.hasIncludes = !this.includes.isEmpty();
        this.hasExcludes = !this.excludes.isEmpty();
    }

    SimpleRetry(int maxAttempts, double multiplier, Duration delay, Duration maxDelay) {
        this(maxAttempts, multiplier, delay, maxDelay, Collections.emptyList(), Collections.emptyList());
    }

    SimpleRetry(int maxAttempts, double multiplier, Duration delay) {
        this(maxAttempts, multiplier, delay, null);
    }

    @Override
    public boolean canRetry(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (this.hasIncludes && this.includes.stream().noneMatch(cls -> cls.isInstance(exception))) {
            return false;
        }
        if (this.hasExcludes && this.excludes.stream().anyMatch(cls -> cls.isInstance(exception))) {
            return false;
        }
        return this.attemptNumber.incrementAndGet() < this.maxAttempts + 1 && (this.maxDelay == null || this.overallDelay.get() < this.maxDelay.toMillis());
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public int currentAttempt() {
        return this.attemptNumber.get();
    }

    @Override
    public OptionalDouble getMultiplier() {
        return this.multiplier > 0.0 ? OptionalDouble.of(this.multiplier) : OptionalDouble.empty();
    }

    @Override
    public Duration getDelay() {
        return this.delay;
    }

    @Override
    public Duration getOverallDelay() {
        return Duration.ofMillis(this.overallDelay.get());
    }

    @Override
    public Optional<Duration> getMaxDelay() {
        return Optional.ofNullable(this.maxDelay);
    }

    @Override
    @Internal
    public long nextDelay() {
        double multiplier = this.getMultiplier().orElse(1.0);
        int current = this.attemptNumber.get() + 1;
        long delay = (long)((double)this.getDelay().toMillis() * multiplier) * (long)current;
        this.overallDelay.addAndGet(delay);
        return delay;
    }
}

