/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.NonBlocking;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpResponse;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.scheduling.exceptions.SchedulerConfigurationException;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.executor.ThreadSelection;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.inject.Singleton;

@Singleton
public class DefaultExecutorSelector
implements ExecutorSelector {
    private final BeanLocator beanLocator;

    protected DefaultExecutorSelector(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    @Override
    public Optional<ExecutorService> select(MethodReference method, ThreadSelection threadSelection) {
        String name = method.stringValue(ExecuteOn.class).orElse(null);
        if (name != null) {
            try {
                ExecutorService executorService = (ExecutorService)this.beanLocator.getBean(ExecutorService.class, Qualifiers.byName((String)name));
                return Optional.of(executorService);
            }
            catch (NoSuchBeanException e) {
                throw new SchedulerConfigurationException(method, "No executor configured for name: " + name);
            }
        }
        if (threadSelection == ThreadSelection.AUTO) {
            Class argumentType;
            Optional generic;
            if (method.hasStereotype(NonBlocking.class)) {
                return Optional.empty();
            }
            Class returnType = method.getReturnType().getType();
            if (this.isNonBlocking(returnType)) {
                return Optional.empty();
            }
            if (HttpResponse.class.isAssignableFrom(returnType) && (generic = method.getReturnType().getFirstTypeVariable()).isPresent() && this.isNonBlocking(argumentType = ((Argument)generic.get()).getType())) {
                return Optional.empty();
            }
            return this.beanLocator.findBean(ExecutorService.class, Qualifiers.byName((String)"io"));
        }
        return Optional.empty();
    }

    private boolean isNonBlocking(Class type) {
        return Publishers.isConvertibleToPublisher((Class)type) || CompletionStage.class.isAssignableFrom(type);
    }
}

