/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedCallable;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedRunnable;
import io.micronaut.scheduling.instrument.MultipleInvocationInstrumenter;
import java.util.Collection;
import java.util.concurrent.Callable;

public interface InvocationInstrumenter {
    public static final InvocationInstrumenter NOOP = new InvocationInstrumenter(){

        @Override
        public void beforeInvocation() {
        }

        @Override
        public void afterInvocation(boolean cleanup) {
        }
    };

    public void beforeInvocation();

    public void afterInvocation(boolean var1);

    default public void afterInvocation() {
        this.afterInvocation(false);
    }

    @NonNull
    public static InvocationInstrumenter combine(Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return NOOP;
        }
        if (invocationInstrumenters.size() == 1) {
            return invocationInstrumenters.iterator().next();
        }
        return new MultipleInvocationInstrumenter(invocationInstrumenters);
    }

    @NonNull
    public static Runnable instrument(@NonNull Runnable runnable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return runnable;
        }
        return InvocationInstrumenter.instrument(runnable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @NonNull
    public static <V> Callable<V> instrument(@NonNull Callable<V> callable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return callable;
        }
        return InvocationInstrumenter.instrument(callable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @NonNull
    public static Runnable instrument(@NonNull Runnable runnable, InvocationInstrumenter invocationInstrumenter) {
        if (runnable instanceof InvocationInstrumenterWrappedRunnable) {
            return runnable;
        }
        return new InvocationInstrumenterWrappedRunnable(invocationInstrumenter, runnable);
    }

    @NonNull
    public static <V> Callable<V> instrument(@NonNull Callable<V> callable, InvocationInstrumenter invocationInstrumenter) {
        if (callable instanceof InvocationInstrumenterWrappedCallable) {
            return callable;
        }
        return new InvocationInstrumenterWrappedCallable<V>(invocationInstrumenter, callable);
    }
}

