/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.util.CollectionUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;

@Introspected
public class FileWatchCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        List paths;
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext && CollectionUtils.isNotEmpty((Collection)(paths = (List)((ApplicationContext)beanContext).getEnvironment().getProperty("micronaut.io.watch.paths", ConversionContext.LIST_OF_STRING).orElse(null)))) {
            boolean matchedPaths = paths.stream().anyMatch(p -> new File((String)p).exists());
            if (!matchedPaths) {
                context.fail("File watch disabled because no paths matching the watch pattern exist (Paths: " + paths + ")");
            }
            return matchedPaths;
        }
        context.fail("File watch disabled because no watch paths specified");
        return false;
    }
}

