/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.convert.ObjectNodeConvertibleValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class JacksonConverterRegistrar
implements TypeConverterRegistrar {
    private final Provider<ObjectMapper> objectMapper;
    private final ConversionService<?> conversionService;
    private final Provider<BeanPropertyBinder> beanPropertyBinder;

    protected JacksonConverterRegistrar(Provider<ObjectMapper> objectMapper, Provider<BeanPropertyBinder> beanPropertyBinder, ConversionService<?> conversionService) {
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
        this.beanPropertyBinder = beanPropertyBinder;
    }

    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(ArrayNode.class, Object[].class, this.arrayNodeToObjectConverter());
        conversionService.addConverter(ArrayNode.class, Iterable.class, this.arrayNodeToIterableConverter());
        conversionService.addConverter(JsonNode.class, Object.class, this.jsonNodeToObjectConverter());
        conversionService.addConverter(ObjectNode.class, ConvertibleValues.class, this.objectNodeToConvertibleValuesConverter());
        conversionService.addConverter(Object.class, JsonNode.class, this.objectToJsonNodeConverter());
        conversionService.addConverter(Map.class, Object.class, this.mapToObjectConverter());
        conversionService.addConverter(CharSequence.class, PropertyNamingStrategy.class, (charSequence, targetType, context) -> {
            String stringValue;
            PropertyNamingStrategy propertyNamingStrategy = null;
            if (charSequence != null && StringUtils.isNotEmpty((CharSequence)(stringValue = NameUtils.environmentName((String)charSequence.toString())))) {
                switch (stringValue) {
                    case "SNAKE_CASE": {
                        propertyNamingStrategy = PropertyNamingStrategy.SNAKE_CASE;
                        break;
                    }
                    case "UPPER_CAMEL_CASE": {
                        propertyNamingStrategy = PropertyNamingStrategy.UPPER_CAMEL_CASE;
                        break;
                    }
                    case "LOWER_CASE": {
                        propertyNamingStrategy = PropertyNamingStrategy.LOWER_CASE;
                        break;
                    }
                    case "KEBAB_CASE": {
                        propertyNamingStrategy = PropertyNamingStrategy.KEBAB_CASE;
                        break;
                    }
                    case "LOWER_CAMEL_CASE": {
                        propertyNamingStrategy = PropertyNamingStrategy.LOWER_CAMEL_CASE;
                        break;
                    }
                }
            }
            if (propertyNamingStrategy == null) {
                context.reject(charSequence, (Exception)new IllegalArgumentException(String.format("Unable to convert '%s' to a com.fasterxml.jackson.databind.PropertyNamingStrategy", charSequence)));
            }
            return Optional.ofNullable(propertyNamingStrategy);
        });
    }

    protected TypeConverter<Map, Object> mapToObjectConverter() {
        return (map, targetType, context) -> {
            ArgumentConversionContext conversionContext = context instanceof ArgumentConversionContext ? (ArgumentConversionContext)context : ConversionContext.of((Class)targetType);
            LinkedHashMap mapWithExtraProps = new LinkedHashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                mapWithExtraProps.put(NameUtils.decapitalize((String)NameUtils.dehyphenate((String)key.toString())), entry.getValue());
            }
            ArgumentBinder binder = (ArgumentBinder)this.beanPropertyBinder.get();
            ArgumentBinder.BindingResult result = binder.bind(conversionContext, mapWithExtraProps);
            Optional opt = result.getValue();
            return opt;
        };
    }

    protected TypeConverter<Object, JsonNode> objectToJsonNodeConverter() {
        return (object, targetType, context) -> {
            try {
                return Optional.of(((ObjectMapper)this.objectMapper.get()).valueToTree(object));
            }
            catch (IllegalArgumentException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    protected TypeConverter<ObjectNode, ConvertibleValues> objectNodeToConvertibleValuesConverter() {
        return (object, targetType, context) -> Optional.of(new ObjectNodeConvertibleValues((ObjectNode)object, this.conversionService));
    }

    protected TypeConverter<JsonNode, Object> jsonNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                Object result;
                if (CharSequence.class.isAssignableFrom(targetType) && node instanceof ObjectNode) {
                    return Optional.of(node.toString());
                }
                Argument argument = null;
                if (node instanceof ContainerNode && context instanceof ArgumentConversionContext && targetType.getTypeParameters().length != 0) {
                    argument = ((ArgumentConversionContext)context).getArgument();
                }
                if (argument != null) {
                    ObjectMapper om = (ObjectMapper)this.objectMapper.get();
                    JsonParser jsonParser = om.treeAsTokens((TreeNode)node);
                    TypeFactory typeFactory = om.getTypeFactory();
                    JavaType javaType = JacksonConfiguration.constructType(argument, typeFactory);
                    result = om.readValue(jsonParser, javaType);
                } else {
                    result = ((ObjectMapper)this.objectMapper.get()).treeToValue((TreeNode)node, targetType);
                }
                return Optional.ofNullable(result);
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    protected TypeConverter<ArrayNode, Iterable> arrayNodeToIterableConverter() {
        return (node, targetType, context) -> {
            Map typeVariables = context.getTypeVariables();
            Class elementType = typeVariables.isEmpty() ? Map.class : ((Argument)typeVariables.values().iterator().next()).getType();
            ArrayList results = new ArrayList();
            node.elements().forEachRemaining(jsonNode -> {
                Optional converted = this.conversionService.convert(jsonNode, elementType, context);
                if (converted.isPresent()) {
                    results.add(converted.get());
                }
            });
            return Optional.of(results);
        };
    }

    protected TypeConverter<ArrayNode, Object[]> arrayNodeToObjectConverter() {
        return (node, targetType, context) -> {
            try {
                Object[] result = (Object[])((ObjectMapper)this.objectMapper.get()).treeToValue((TreeNode)node, targetType);
                return Optional.of(result);
            }
            catch (JsonProcessingException e) {
                context.reject((Exception)((Object)e));
                return Optional.empty();
            }
        };
    }
}

