/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.async.processor.SingleThreadedBufferingProcessor;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonProcessor
extends SingleThreadedBufferingProcessor<byte[], JsonNode> {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonProcessor.class);
    private NonBlockingJsonParser currentNonBlockingJsonParser;
    private final ConcurrentLinkedDeque<JsonNode> nodeStack = new ConcurrentLinkedDeque();
    private final JsonFactory jsonFactory;
    @Nullable
    private final DeserializationConfig deserializationConfig;
    private String currentFieldName;
    private boolean streamArray;
    private boolean rootIsArray;
    private boolean jsonStream;

    public JacksonProcessor(JsonFactory jsonFactory, boolean streamArray, @Nullable DeserializationConfig deserializationConfig) {
        try {
            this.jsonFactory = jsonFactory;
            this.deserializationConfig = deserializationConfig;
            this.currentNonBlockingJsonParser = (NonBlockingJsonParser)jsonFactory.createNonBlockingByteArrayParser();
            this.streamArray = streamArray;
            this.jsonStream = true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create non-blocking JSON parser: " + e.getMessage(), e);
        }
    }

    public JacksonProcessor(JsonFactory jsonFactory, boolean streamArray) {
        this(jsonFactory, streamArray, null);
    }

    public JacksonProcessor(JsonFactory jsonFactory, DeserializationConfig deserializationConfig) {
        this(jsonFactory, false, deserializationConfig);
    }

    public JacksonProcessor(JsonFactory jsonFactory) {
        this(jsonFactory, false, null);
    }

    public JacksonProcessor(DeserializationConfig deserializationConfig) {
        this(new JsonFactory(), deserializationConfig);
    }

    public JacksonProcessor() {
        this(new JsonFactory(), null);
    }

    public boolean needMoreInput() {
        return this.currentNonBlockingJsonParser.getNonBlockingInputFeeder().needMoreInput();
    }

    protected void doOnComplete() {
        if (this.needMoreInput()) {
            this.doOnError((Throwable)new JsonEOFException((JsonParser)this.currentNonBlockingJsonParser, JsonToken.NOT_AVAILABLE, "Unexpected end-of-input"));
        } else {
            super.doOnComplete();
        }
    }

    protected void onUpstreamMessage(byte[] message) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received upstream bytes of length: " + message.length);
            }
            if (message.length == 0) {
                if (this.needMoreInput()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("More input required to parse JSON. Demanding more.");
                    }
                    this.upstreamSubscription.request(1L);
                    ++this.upstreamDemand;
                }
                return;
            }
            ByteArrayFeeder byteFeeder = this.currentNonBlockingJsonParser.getNonBlockingInputFeeder();
            boolean needMoreInput = byteFeeder.needMoreInput();
            if (!needMoreInput) {
                this.currentNonBlockingJsonParser = (NonBlockingJsonParser)this.jsonFactory.createNonBlockingByteArrayParser();
                byteFeeder = this.currentNonBlockingJsonParser.getNonBlockingInputFeeder();
            }
            byteFeeder.feedInput(message, 0, message.length);
            JsonToken event = this.currentNonBlockingJsonParser.nextToken();
            if (event == JsonToken.START_ARRAY && this.nodeStack.peekFirst() == null) {
                this.rootIsArray = true;
                this.jsonStream = false;
            }
            while (event != JsonToken.NOT_AVAILABLE) {
                JsonNode root = this.asJsonNode(event);
                if (root != null) {
                    boolean isLast;
                    boolean bl = isLast = this.nodeStack.isEmpty() && !this.jsonStream;
                    if (isLast) {
                        byteFeeder.endOfInput();
                    }
                    if (isLast && this.streamArray && root instanceof ArrayNode) break;
                    this.currentDownstreamSubscriber().ifPresent(subscriber -> {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Materialized new JsonNode call onNext...");
                        }
                        subscriber.onNext((Object)root);
                    });
                    if (isLast) break;
                }
                event = this.currentNonBlockingJsonParser.nextToken();
            }
            if (this.jsonStream && this.nodeStack.isEmpty()) {
                byteFeeder.endOfInput();
            }
            if (this.jsonStream || this.needMoreInput()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("More input required to parse JSON. Demanding more.");
                }
                this.upstreamSubscription.request(1L);
                ++this.upstreamDemand;
            }
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    private JsonNode asJsonNode(JsonToken event) throws IOException {
        ArrayNode arrayNode;
        block0 : switch (event) {
            case START_OBJECT: {
                this.nodeStack.push(this.node(this.nodeStack.peekFirst()));
                break;
            }
            case START_ARRAY: {
                JsonNode node = this.nodeStack.peekFirst();
                if (node == null) {
                    this.rootIsArray = true;
                }
                this.nodeStack.push(this.array(node));
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected array end literal");
                }
                JsonNode current = this.nodeStack.pop();
                if (this.nodeStack.isEmpty()) {
                    return current;
                }
                if (this.streamArray && this.nodeStack.size() == 1) {
                    JsonNode jsonNode = this.nodeStack.peekFirst();
                    if (jsonNode instanceof ArrayNode) {
                        return current;
                    }
                    return null;
                }
                return null;
            }
            case FIELD_NAME: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected field literal");
                }
                this.currentFieldName = this.currentNonBlockingJsonParser.getCurrentName();
                break;
            }
            case VALUE_NUMBER_INT: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected integer literal");
                }
                JsonParser.NumberType numberIntType = this.currentNonBlockingJsonParser.getNumberType();
                JsonNode integerNode = this.nodeStack.peekFirst();
                switch (numberIntType) {
                    case BIG_INTEGER: {
                        if (integerNode instanceof ObjectNode) {
                            ((ObjectNode)integerNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBigIntegerValue());
                            break block0;
                        }
                        ((ArrayNode)integerNode).add(this.currentNonBlockingJsonParser.getBigIntegerValue());
                        break block0;
                    }
                    case LONG: {
                        if (this.deserializationConfig != null && this.deserializationConfig.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                            if (integerNode instanceof ObjectNode) {
                                ((ObjectNode)integerNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBigIntegerValue());
                                break block0;
                            }
                            ((ArrayNode)integerNode).add(this.currentNonBlockingJsonParser.getBigIntegerValue());
                            break block0;
                        }
                        if (integerNode instanceof ObjectNode) {
                            ((ObjectNode)integerNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getLongValue());
                            break block0;
                        }
                        ((ArrayNode)integerNode).add(this.currentNonBlockingJsonParser.getLongValue());
                        break block0;
                    }
                    case INT: {
                        if (this.deserializationConfig != null && this.deserializationConfig.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                            if (integerNode instanceof ObjectNode) {
                                ((ObjectNode)integerNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBigIntegerValue());
                                break block0;
                            }
                            ((ArrayNode)integerNode).add(this.currentNonBlockingJsonParser.getBigIntegerValue());
                            break block0;
                        }
                        if (integerNode instanceof ObjectNode) {
                            ((ObjectNode)integerNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getIntValue());
                            break block0;
                        }
                        ((ArrayNode)integerNode).add(this.currentNonBlockingJsonParser.getIntValue());
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported number type: " + numberIntType);
            }
            case VALUE_STRING: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected string literal");
                }
                JsonNode stringNode = this.nodeStack.peekFirst();
                if (stringNode instanceof ObjectNode) {
                    ((ObjectNode)stringNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getValueAsString());
                    break;
                }
                ((ArrayNode)stringNode).add(this.currentNonBlockingJsonParser.getValueAsString());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected float literal");
                }
                JsonParser.NumberType numberDecimalType = this.currentNonBlockingJsonParser.getNumberType();
                JsonNode decimalNode = this.nodeStack.peekFirst();
                switch (numberDecimalType) {
                    case FLOAT: {
                        if (this.deserializationConfig != null && this.deserializationConfig.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                            if (decimalNode instanceof ObjectNode) {
                                ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDecimalValue());
                                break block0;
                            }
                            ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDecimalValue());
                            break block0;
                        }
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getFloatValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getFloatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        if (this.deserializationConfig != null && this.deserializationConfig.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                            if (decimalNode instanceof ObjectNode) {
                                ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDecimalValue());
                                break block0;
                            }
                            ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDecimalValue());
                            break block0;
                        }
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDoubleValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDoubleValue());
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        if (decimalNode instanceof ObjectNode) {
                            ((ObjectNode)decimalNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getDecimalValue());
                            break block0;
                        }
                        ((ArrayNode)decimalNode).add(this.currentNonBlockingJsonParser.getDecimalValue());
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported number type: " + numberDecimalType);
            }
            case VALUE_NULL: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected null literal");
                }
                JsonNode nullNode = this.nodeStack.peekFirst();
                if (nullNode instanceof ObjectNode) {
                    ((ObjectNode)nullNode).putNull(this.currentFieldName);
                    break;
                }
                ((ArrayNode)nullNode).addNull();
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                if (this.nodeStack.isEmpty()) {
                    throw new JsonParseException((JsonParser)this.currentNonBlockingJsonParser, "Unexpected boolean literal");
                }
                JsonNode booleanNode = this.nodeStack.peekFirst();
                if (booleanNode instanceof ObjectNode) {
                    ((ObjectNode)booleanNode).put(this.currentFieldName, this.currentNonBlockingJsonParser.getBooleanValue());
                    break;
                }
                ((ArrayNode)booleanNode).add(this.currentNonBlockingJsonParser.getBooleanValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported JSON event: " + event);
            }
        }
        if (this.rootIsArray && this.streamArray && this.nodeStack.size() == 1 && (arrayNode = (ArrayNode)this.nodeStack.peekFirst()).size() > 0) {
            return arrayNode.remove(arrayNode.size() - 1);
        }
        return null;
    }

    private JsonNode array(JsonNode node) {
        if (node instanceof ObjectNode) {
            return ((ObjectNode)node).putArray(this.currentFieldName);
        }
        if (node instanceof ArrayNode) {
            return ((ArrayNode)node).addArray();
        }
        return this.deserializationConfig.getNodeFactory().arrayNode();
    }

    private JsonNode node(JsonNode node) {
        if (node instanceof ObjectNode) {
            return ((ObjectNode)node).putObject(this.currentFieldName);
        }
        if (node instanceof ArrayNode && (!this.streamArray || this.nodeStack.size() != 1)) {
            return ((ArrayNode)node).addObject();
        }
        return this.deserializationConfig.getNodeFactory().objectNode();
    }
}

