/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.retry.annotation.Fallback;
import io.micronaut.retry.annotation.Recoverable;
import io.micronaut.retry.exception.FallbackException;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecoveryInterceptor
implements MethodInterceptor<Object, Object> {
    public static final int POSITION = InterceptPhase.RETRY.getPosition() - 10;
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryInterceptor.class);
    private final BeanContext beanContext;

    public RecoveryInterceptor(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public int getOrder() {
        return POSITION;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        try {
            Object result = context.proceed();
            if (result != null) {
                if (result instanceof CompletableFuture) {
                    return this.fallbackForFuture(context, (CompletableFuture)result);
                }
                if (Publishers.isConvertibleToPublisher(result.getClass())) {
                    return this.fallbackForReactiveType(context, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            return this.resolveFallback(context, e);
        }
    }

    private <T> T fallbackForReactiveType(MethodInvocationContext<Object, Object> context, T result) {
        Flowable recoveryFlowable = (Flowable)ConversionService.SHARED.convert(result, Flowable.class).orElseThrow(() -> new FallbackException("Unsupported Reactive type: " + result));
        recoveryFlowable = recoveryFlowable.onErrorResumeNext(throwable -> {
            Optional<MethodExecutionHandle<?, Object>> fallbackMethod = this.findFallbackMethod(context);
            if (fallbackMethod.isPresent()) {
                Object fallbackResult;
                MethodExecutionHandle<?, Object> fallbackHandle = fallbackMethod.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Type [{}] resolved fallback: {}", context.getTarget().getClass(), fallbackHandle);
                }
                try {
                    fallbackResult = fallbackHandle.invoke(context.getParameterValues());
                }
                catch (Exception e) {
                    return Flowable.error((Throwable)throwable);
                }
                if (fallbackResult == null) {
                    return Flowable.error((Throwable)new FallbackException("Fallback handler [" + fallbackHandle + "] returned null value"));
                }
                return (Publisher)ConversionService.SHARED.convert(fallbackResult, Publisher.class).orElseThrow(() -> new FallbackException("Unsupported Reactive type: " + fallbackResult));
            }
            return Flowable.error((Throwable)throwable);
        });
        return ConversionService.SHARED.convert((Object)recoveryFlowable, context.getReturnType().asArgument()).orElseThrow(() -> new FallbackException("Unsupported Reactive type: " + result));
    }

    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod fallBackMethod;
        BeanDefinition beanDefinition;
        Class declaringType = context.classValue(Recoverable.class, "api").orElse(null);
        if (declaringType == null) {
            declaringType = context.getDeclaringType();
        }
        if ((beanDefinition = (BeanDefinition)this.beanContext.findBeanDefinition(declaringType, Qualifiers.byStereotype(Fallback.class)).orElse(null)) != null && (fallBackMethod = (ExecutableMethod)beanDefinition.findMethod(context.getMethodName(), context.getArgumentTypes()).orElse(null)) != null) {
            MethodExecutionHandle executionHandle = this.beanContext.createExecutionHandle(beanDefinition, fallBackMethod);
            return Optional.of(executionHandle);
        }
        return Optional.empty();
    }

    private Object fallbackForFuture(MethodInvocationContext<Object, Object> context, CompletableFuture result) {
        CompletableFuture newFuture = new CompletableFuture();
        result.whenComplete((o, throwable) -> {
            block9: {
                if (throwable == null) {
                    newFuture.complete(o);
                } else {
                    Optional<MethodExecutionHandle<?, Object>> fallbackMethod = this.findFallbackMethod(context);
                    if (fallbackMethod.isPresent()) {
                        MethodExecutionHandle<?, Object> fallbackHandle = fallbackMethod.get();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Type [{}] resolved fallback: {}", context.getTarget().getClass(), fallbackHandle);
                        }
                        try {
                            CompletableFuture resultingFuture = (CompletableFuture)fallbackHandle.invoke(context.getParameterValues());
                            if (resultingFuture == null) {
                                newFuture.completeExceptionally(new FallbackException("Fallback handler [" + fallbackHandle + "] returned null value"));
                                break block9;
                            }
                            resultingFuture.whenComplete((o1, throwable1) -> {
                                if (throwable1 == null) {
                                    newFuture.complete(o1);
                                } else {
                                    newFuture.completeExceptionally((Throwable)throwable1);
                                }
                            });
                        }
                        catch (Exception e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error("Error invoking Fallback [" + fallbackHandle + "]: " + e.getMessage(), (Throwable)e);
                            }
                            newFuture.completeExceptionally((Throwable)throwable);
                        }
                    } else {
                        newFuture.completeExceptionally((Throwable)throwable);
                    }
                }
            }
        });
        return newFuture;
    }

    protected Object resolveFallback(MethodInvocationContext<Object, Object> context, RuntimeException exception) {
        if (exception instanceof NoAvailableServiceException) {
            NoAvailableServiceException nase = (NoAvailableServiceException)exception;
            if (LOG.isErrorEnabled()) {
                LOG.debug(nase.getMessage(), (Throwable)nase);
                LOG.error("Type [{}] attempting to resolve fallback for unavailable service [{}]", (Object)context.getTarget().getClass().getName(), (Object)nase.getServiceID());
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Type [" + context.getTarget().getClass().getName() + "] executed with error: " + exception.getMessage(), (Throwable)exception);
        }
        Optional<MethodExecutionHandle<?, Object>> fallback = this.findFallbackMethod(context);
        if (fallback.isPresent()) {
            MethodExecutionHandle<?, Object> fallbackMethod = fallback.get();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Type [{}] resolved fallback: {}", (Object)context.getTarget().getClass().getName(), fallbackMethod);
                }
                return fallbackMethod.invoke(context.getParameterValues());
            }
            catch (Exception e) {
                throw new FallbackException("Error invoking fallback for type [" + context.getTarget().getClass().getName() + "]: " + e.getMessage(), e);
            }
        }
        throw exception;
    }
}

