/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.async;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.TaskExecutors;
import io.micronaut.scheduling.annotation.Async;
import io.micronaut.scheduling.exceptions.TaskExecutionException;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class AsyncInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutors.class);
    private final BeanLocator beanLocator;

    AsyncInterceptor(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return InterceptPhase.ASYNC.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        String executorName = context.stringValue(Async.class).orElse("scheduled");
        ExecutorService executorService = (ExecutorService)this.beanLocator.findBean(ExecutorService.class, Qualifiers.byName((String)executorName)).orElseThrow(() -> new TaskExecutionException("No ExecutorService named [" + executorName + "] configured in application context"));
        ReturnType rt = context.getReturnType();
        Class returnType = rt.getType();
        if (CompletionStage.class.isAssignableFrom(returnType) || Future.class.isAssignableFrom(returnType)) {
            CompletableFuture newFuture = new CompletableFuture();
            executorService.submit(() -> {
                CompletionStage completionStage = (CompletionStage)context.proceed();
                if (completionStage == null) {
                    newFuture.complete(null);
                } else {
                    completionStage.whenComplete((o, throwable) -> {
                        if (throwable != null) {
                            newFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            newFuture.complete(o);
                        }
                    });
                }
            });
            return newFuture;
        }
        if (Void.TYPE == returnType) {
            executorService.submit(() -> {
                block2: {
                    try {
                        context.proceed();
                    }
                    catch (Throwable e) {
                        if (!LOG.isErrorEnabled()) break block2;
                        LOG.error("Error occurred executing @Async method [" + context.getExecutableMethod() + "]: " + e.getMessage(), e);
                    }
                }
            });
            return null;
        }
        if (Publishers.isConvertibleToPublisher((Class)returnType)) {
            Object result = context.proceed();
            Flowable flowable = (Flowable)Publishers.convertPublisher((Object)result, Flowable.class);
            CompletableFuture newFuture = new CompletableFuture();
            flowable.subscribeOn(Schedulers.from((Executor)executorService)).subscribe(newFuture::complete, newFuture::completeExceptionally);
            return Publishers.convertPublisher((Object)Publishers.fromCompletableFuture(newFuture), (Class)returnType);
        }
        throw new TaskExecutionException("Method [" + context.getExecutableMethod() + "] must return either void, or an instance of Publisher or CompletionStage");
    }
}

