/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.codec.JacksonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Named(value="json")
@Singleton
@BootstrapContextCompatible
public class JsonMediaTypeCodec
extends JacksonMediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "json";

    public JsonMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, codecConfiguration, MediaType.APPLICATION_JSON_TYPE);
    }

    @Inject
    public JsonMediaTypeCodec(Provider<ObjectMapper> objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, codecConfiguration, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public JacksonMediaTypeCodec cloneWithFeatures(JacksonFeatures jacksonFeatures) {
        ObjectMapper objectMapper = this.getObjectMapper().copy();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        return new JsonMediaTypeCodec(objectMapper, this.applicationConfiguration, this.codecConfiguration);
    }
}

