/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;

public abstract class JacksonMediaTypeCodec
implements MediaTypeCodec {
    protected final ApplicationConfiguration applicationConfiguration;
    protected final List<MediaType> additionalTypes;
    protected final CodecConfiguration codecConfiguration;
    protected final MediaType mediaType;
    private final BeanProvider<ObjectMapper> objectMapperProvider;
    private ObjectMapper objectMapper;

    @Deprecated
    public JacksonMediaTypeCodec(Provider<ObjectMapper> objectMapperProvider, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        this((BeanProvider<ObjectMapper>)((BeanProvider)() -> objectMapperProvider.get()), applicationConfiguration, codecConfiguration, mediaType);
    }

    public JacksonMediaTypeCodec(BeanProvider<ObjectMapper> objectMapperProvider, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        this.objectMapperProvider = objectMapperProvider;
        this.applicationConfiguration = applicationConfiguration;
        this.codecConfiguration = codecConfiguration;
        this.mediaType = mediaType;
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    public JacksonMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, CodecConfiguration codecConfiguration, MediaType mediaType) {
        this((BeanProvider<ObjectMapper>)((BeanProvider)() -> objectMapper), applicationConfiguration, codecConfiguration, mediaType);
        ArgumentUtils.requireNonNull((String)"objectMapper", (Object)objectMapper);
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = this.objectMapper;
        if (objectMapper == null) {
            JacksonMediaTypeCodec jacksonMediaTypeCodec = this;
            synchronized (jacksonMediaTypeCodec) {
                objectMapper = this.objectMapper;
                if (objectMapper == null) {
                    this.objectMapper = objectMapper = (ObjectMapper)this.objectMapperProvider.get();
                }
            }
        }
        return objectMapper;
    }

    public abstract JacksonMediaTypeCodec cloneWithFeatures(JacksonFeatures var1);

    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(this.mediaType);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }

    public boolean supportsType(Class<?> type) {
        return !CharSequence.class.isAssignableFrom(type);
    }

    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.getObjectMapper().readValue(inputStream, javaType);
            }
            return (T)this.getObjectMapper().readValue(inputStream, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, JsonNode node) throws CodecException {
        try {
            return (T)this.getObjectMapper().treeToValue((TreeNode)node, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        try {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                return (T)buffer.toString(this.applicationConfiguration.getDefaultCharset());
            }
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.getObjectMapper().readValue(buffer.toByteArray(), javaType);
            }
            return (T)this.getObjectMapper().readValue(buffer.toByteArray(), type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding stream for type [" + type.getType() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, byte[] bytes) throws CodecException {
        try {
            if (CharSequence.class.isAssignableFrom(type.getType())) {
                return (T)new String(bytes, this.applicationConfiguration.getDefaultCharset());
            }
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.getObjectMapper().readValue(bytes, javaType);
            }
            return (T)this.getObjectMapper().readValue(bytes, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding stream for type [" + type.getType() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, String data) throws CodecException {
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return (T)this.getObjectMapper().readValue(data, javaType);
            }
            return (T)this.getObjectMapper().readValue(data, type.getType());
        }
        catch (IOException e) {
            throw new CodecException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        try {
            this.getObjectMapper().writeValue(outputStream, object);
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> byte[] encode(T object) throws CodecException {
        try {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return this.getObjectMapper().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T, B> ByteBuffer<B> encode(T object, ByteBufferFactory<?, B> allocator) throws CodecException {
        byte[] bytes = this.encode(object);
        return allocator.copiedBuffer(bytes);
    }

    private <T> JavaType constructJavaType(Argument<T> type) {
        TypeFactory typeFactory = this.getObjectMapper().getTypeFactory();
        return JacksonConfiguration.constructType(type, typeFactory);
    }
}

