/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.http.scope;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.http.scope.RequestAware;
import io.micronaut.runtime.http.scope.RequestScope;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class RequestCustomScope
implements CustomScope<RequestScope>,
LifeCycle<RequestCustomScope>,
ApplicationEventListener<HttpRequestTerminatedEvent> {
    public static final String SCOPED_BEANS_ATTRIBUTE = "io.micronaut.http.SCOPED_BEANS";
    public static final String SCOPED_BEAN_DEFINITIONS_ATTRIBUTE = "io.micronaut.http.SCOPED_BEAN_DEFINITIONS";
    private static final Logger LOG = LoggerFactory.getLogger(RequestCustomScope.class);
    private final BeanContext beanContext;

    public RequestCustomScope(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public Class<RequestScope> annotationType() {
        return RequestScope.class;
    }

    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        Optional currentRequest = ServerRequestContext.currentRequest();
        if (!currentRequest.isPresent()) {
            throw new NoSuchBeanException(beanDefinition.getBeanType(), Qualifiers.byStereotype(RequestScope.class));
        }
        HttpRequest httpRequest = (HttpRequest)currentRequest.get();
        return (T)this.getRequestScopedBeans(httpRequest, true).computeIfAbsent(identifier, i -> {
            Object bean = provider.get();
            if (bean instanceof RequestAware) {
                ((RequestAware)bean).setRequest(httpRequest);
            }
            this.getRequestScopedBeanDefinitions(httpRequest, true).put(identifier, beanDefinition);
            return bean;
        });
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        Optional request = ServerRequestContext.currentRequest();
        if (request.isPresent()) {
            Object bean = this.getRequestScopedBeans((HttpRequest)request.get(), true).remove(identifier);
            BeanDefinition beanDefinition = this.getRequestScopedBeanDefinitions((HttpRequest)request.get(), true).remove(identifier);
            this.destroyRequestScopedBean(bean, beanDefinition);
            return Optional.ofNullable(bean);
        }
        return Optional.empty();
    }

    private <T> void destroyRequestScopedBean(@Nullable T bean, @Nullable BeanDefinition<T> beanDefinition) {
        block3: {
            if (bean != null && beanDefinition instanceof DisposableBeanDefinition) {
                try {
                    ((DisposableBeanDefinition)beanDefinition).dispose(this.beanContext, bean);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error("Error disposing of request scoped bean: " + bean, (Throwable)e);
                }
            }
        }
    }

    @NonNull
    public RequestCustomScope stop() {
        ServerRequestContext.currentRequest().ifPresent(this::destroyBeans);
        return this;
    }

    public boolean isRunning() {
        return true;
    }

    public void onApplicationEvent(HttpRequestTerminatedEvent event) {
        this.destroyBeans(event.getSource());
    }

    private void destroyBeans(HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"request", request);
        ConcurrentHashMap<BeanIdentifier, Object> requestScopedBeans = this.getRequestScopedBeans(request, false);
        if (requestScopedBeans != null) {
            requestScopedBeans.forEach((beanIdentifier, instance) -> {
                BeanDefinition beanDefinition = this.getRequestScopedBeanDefinitions(request, false).get(beanIdentifier);
                this.destroyRequestScopedBean(instance, beanDefinition);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ConcurrentHashMap<BeanIdentifier, Object> getRequestScopedBeans(HttpRequest<T> httpRequest, boolean create) {
        HttpRequest<T> httpRequest2 = httpRequest;
        synchronized (httpRequest2) {
            return this.getRequestAttributeMap(httpRequest, SCOPED_BEANS_ATTRIBUTE, create);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ConcurrentHashMap<BeanIdentifier, BeanDefinition> getRequestScopedBeanDefinitions(HttpRequest<T> httpRequest, boolean create) {
        HttpRequest<T> httpRequest2 = httpRequest;
        synchronized (httpRequest2) {
            return this.getRequestAttributeMap(httpRequest, SCOPED_BEAN_DEFINITIONS_ATTRIBUTE, create);
        }
    }

    private <T> ConcurrentHashMap getRequestAttributeMap(HttpRequest<T> httpRequest, String attribute, boolean create) {
        MutableConvertibleValues attrs = httpRequest.getAttributes();
        Object o = attrs.getValue((CharSequence)attribute);
        if (o instanceof ConcurrentHashMap) {
            return (ConcurrentHashMap)o;
        }
        if (create) {
            ConcurrentHashMap scopedBeans = new ConcurrentHashMap(5);
            attrs.put((CharSequence)attribute, scopedBeans);
            return scopedBeans;
        }
        return null;
    }
}

